/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.shipping.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.commons.exceptions.CubeException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.api.exception.InventoryExceptionCode;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.response.PackageSplitConfigRespDto;
import com.dtyunxi.yundt.cube.center.shipping.biz.service.IPackageSplitConfigService;
import com.dtyunxi.yundt.cube.center.shipping.dao.das.PackageSplitConfigDas;
import com.dtyunxi.yundt.cube.center.shipping.dao.eo.PackageSplitConfigEo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PackageSplitConfigServiceImpl
implements IPackageSplitConfigService {
    private static final Logger logger = LoggerFactory.getLogger(PackageSplitConfigServiceImpl.class);
    @Resource
    private PackageSplitConfigDas packageSplitConfigDas;

    @Override
    public Long addPackageSplitConfig(PackageSplitConfigEo packageSplitConfigEo) {
        PackageSplitConfigEo eo = new PackageSplitConfigEo();
        eo.setCode(packageSplitConfigEo.getCode());
        List packageSplitConfigEos = this.packageSplitConfigDas.select((BaseEo)eo);
        if (CollectionUtils.isNotEmpty((Collection)packageSplitConfigEos)) {
            logger.error(InventoryExceptionCode.CODE_DUPLICATED.getCode(), (Object)InventoryExceptionCode.CODE_DUPLICATED.getMsg());
            throw new BizException(InventoryExceptionCode.CODE_DUPLICATED.getCode(), InventoryExceptionCode.CODE_DUPLICATED.getMsg());
        }
        this.packageSplitConfigDas.insert((BaseEo)packageSplitConfigEo);
        return packageSplitConfigEo.getId();
    }

    @Override
    public void modifyPackageSplitConfig(PackageSplitConfigEo packageSplitConfigEo) {
        this.packageSplitConfigDas.updateSelective((BaseEo)packageSplitConfigEo);
    }

    @Override
    public void removeByIds(List<Long> ids) {
        PackageSplitConfigEo packageSplitConfigEo = new PackageSplitConfigEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"id", (Object)StringUtils.join(ids, (String)",")));
        packageSplitConfigEo.setSqlFilters(sqlFilters);
        this.packageSplitConfigDas.logicDeleteByExample((BaseEo)packageSplitConfigEo);
    }

    @Override
    public void removeByCode(String code) {
        PackageSplitConfigEo packageSplitConfigEo = new PackageSplitConfigEo();
        packageSplitConfigEo.setCode(code);
        PackageSplitConfigEo configEo = (PackageSplitConfigEo)this.packageSplitConfigDas.selectOne((BaseEo)packageSplitConfigEo);
        if (null != configEo) {
            this.packageSplitConfigDas.logicDeleteById(configEo.getId());
        }
    }

    @Override
    public PackageSplitConfigRespDto queryById(Long id) {
        PackageSplitConfigEo packageSplitConfigEo = (PackageSplitConfigEo)this.packageSplitConfigDas.selectByPrimaryKey(id);
        if (null == packageSplitConfigEo) {
            logger.error(InventoryExceptionCode.RECORD_NOT_EXIST.getCode(), (Object)InventoryExceptionCode.RECORD_NOT_EXIST.getMsg());
            throw new CubeException(InventoryExceptionCode.RECORD_NOT_EXIST.getCode(), InventoryExceptionCode.RECORD_NOT_EXIST.getMsg());
        }
        PackageSplitConfigRespDto packageSplitConfigResqDto = new PackageSplitConfigRespDto();
        DtoHelper.eo2Dto((BaseEo)packageSplitConfigEo, (BaseVo)packageSplitConfigResqDto);
        return packageSplitConfigResqDto;
    }

    @Override
    public PackageSplitConfigRespDto queryByCode(String code) {
        PackageSplitConfigEo packageSplitConfigEo = new PackageSplitConfigEo();
        packageSplitConfigEo.setCode(code);
        PackageSplitConfigEo ConfigEo = (PackageSplitConfigEo)this.packageSplitConfigDas.selectOne((BaseEo)packageSplitConfigEo);
        if (null == ConfigEo) {
            logger.error(InventoryExceptionCode.RECORD_NOT_EXIST.getCode(), (Object)InventoryExceptionCode.RECORD_NOT_EXIST.getMsg());
            throw new CubeException(InventoryExceptionCode.RECORD_NOT_EXIST.getCode(), InventoryExceptionCode.RECORD_NOT_EXIST.getMsg());
        }
        PackageSplitConfigRespDto ResqDto = new PackageSplitConfigRespDto();
        DtoHelper.eo2Dto((BaseEo)ConfigEo, (BaseVo)ResqDto);
        return ResqDto;
    }

    @Override
    public List<PackageSplitConfigRespDto> queryByGroupId(Long groupId) {
        PackageSplitConfigEo packageSplitConfigEo = new PackageSplitConfigEo();
        packageSplitConfigEo.setGroupId(groupId);
        List packageSplitConfigEos = this.packageSplitConfigDas.select((BaseEo)packageSplitConfigEo);
        ArrayList<PackageSplitConfigRespDto> packageSplitConfigResqDtos = new ArrayList<PackageSplitConfigRespDto>();
        if (!CollectionUtils.isEmpty((Collection)packageSplitConfigEos)) {
            DtoHelper.eoList2DtoList((Collection)packageSplitConfigEos, packageSplitConfigResqDtos, PackageSplitConfigRespDto.class);
        }
        return packageSplitConfigResqDtos;
    }

    @Override
    public PageInfo<PackageSplitConfigRespDto> queryByPage(PackageSplitConfigEo packageSplitConfigEo, Integer pageNum, Integer pageSize) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        PageInfo packageSplitConfigEoPageInfo = this.packageSplitConfigDas.selectPage((BaseEo)packageSplitConfigEo, pageNum, pageSize);
        PageInfo packageSplitConfigRespDtoPageInfo = new PageInfo();
        ArrayList packageSplitConfigRespDtos = new ArrayList();
        CubeBeanUtils.copyProperties((Object)packageSplitConfigRespDtoPageInfo, (Object)packageSplitConfigEoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        DtoHelper.eoList2DtoList((Collection)packageSplitConfigEoPageInfo.getList(), packageSplitConfigRespDtos, PackageSplitConfigRespDto.class);
        packageSplitConfigRespDtoPageInfo.setList(packageSplitConfigRespDtos);
        return packageSplitConfigRespDtoPageInfo;
    }
}

