/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.shipping.biz.service.impl;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.PackageDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.PackageDetailDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.PackageDetailEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.PackageEo;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.request.CargoDetailReqDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.request.PackageDetailDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.request.PackageDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.response.FreightForOperatorRespDto;
import com.dtyunxi.yundt.cube.center.shipping.biz.mq.vo.DeliveryOrderDetailVo;
import com.dtyunxi.yundt.cube.center.shipping.biz.mq.vo.DeliveryOrderMessageVo;
import com.dtyunxi.yundt.cube.center.shipping.biz.service.IFreightChargeService;
import com.dtyunxi.yundt.cube.center.shipping.biz.service.IPackageSplitService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PackageSplitServiceImpl
implements IPackageSplitService {
    private final Logger logger = LoggerFactory.getLogger(PackageSplitServiceImpl.class);
    @Resource
    private IFreightChargeService freightChargeService;
    @Resource
    private PackageDas packageDas;
    @Resource
    private PackageDetailDas packageDetailDas;
    private final Long workerId = IdGenrator.getWorkerId();

    @Override
    @Transactional
    public List<PackageDto> packageSplit(DeliveryOrderMessageVo deliveryOrderMessageVo) {
        this.logger.info("\u8ba2\u5355[" + deliveryOrderMessageVo.getOrderNo() + "]\u6b63\u5728\u62c6\u5355");
        this.logger.info("\u53d1\u8d27\u5355[" + deliveryOrderMessageVo.getDeliveryOrderNo() + "]\u6b63\u5728\u62c6\u5355");
        ArrayList<PackageDto> packageRespDtos = new ArrayList<PackageDto>();
        Long deliveryOrderId = deliveryOrderMessageVo.getDeliveryOrderId();
        List<DeliveryOrderDetailVo> deliveryOrderDetailVos = deliveryOrderMessageVo.getDeliveryOrderDetailVos();
        HashSet<Long> configSet = new HashSet<Long>();
        for (DeliveryOrderDetailVo deliveryOrderDetailVo : deliveryOrderDetailVos) {
            configSet.add(deliveryOrderDetailVo.getPackageSplitId());
        }
        Map<Long, List<DeliveryOrderDetailVo>> deliveryOrderDetailVoMap = deliveryOrderDetailVos.stream().collect(Collectors.groupingBy(DeliveryOrderDetailVo::getPackageSplitId));
        for (Long config : configSet) {
            PackageDto packageRespDto = new PackageDto();
            PackageEo packageEo = new PackageEo();
            packageEo.setDeliveryOrderId(deliveryOrderId);
            packageEo.setDeliveryOrderNo(deliveryOrderMessageVo.getDeliveryOrderNo());
            packageEo.setOrderId(deliveryOrderMessageVo.getOrderId());
            packageEo.setOrderNo(deliveryOrderMessageVo.getOrderNo());
            packageEo.setInstanceId(deliveryOrderMessageVo.getInstanceId());
            packageEo.setTenantId(deliveryOrderMessageVo.getTenantId());
            packageEo.setPackageNo(this.getCode());
            packageEo.setStatus("INIT");
            packageEo.setRecipients(deliveryOrderMessageVo.getRecipients());
            packageEo.setProvCode(deliveryOrderMessageVo.getProvCode());
            packageEo.setCityCode(deliveryOrderMessageVo.getCityCode());
            packageEo.setAreaCode(deliveryOrderMessageVo.getAreaCode());
            packageEo.setAddress(deliveryOrderMessageVo.getAddress());
            ArrayList<CargoDetailReqDto> cargoDetailReqDtos = new ArrayList<CargoDetailReqDto>();
            List<DeliveryOrderDetailVo> deliveryOrderDetailVos1 = deliveryOrderDetailVoMap.get(config);
            for (DeliveryOrderDetailVo deliveryOrderDetailVo : deliveryOrderDetailVos1) {
                CargoDetailReqDto cargoDetailReqDto = new CargoDetailReqDto();
                cargoDetailReqDto.setCargoId(deliveryOrderDetailVo.getCargoId());
                cargoDetailReqDto.setNum(deliveryOrderDetailVo.getNum());
                cargoDetailReqDto.setShippingTplId(deliveryOrderDetailVo.getShippingTplId());
                cargoDetailReqDto.setQuantity(deliveryOrderDetailVo.getQuantity());
                cargoDetailReqDto.setVolume(deliveryOrderDetailVo.getVolume());
                if (deliveryOrderDetailVo.getShippingTplId() == null || deliveryOrderDetailVo.getShippingTplId().equals(0L)) continue;
                cargoDetailReqDtos.add(cargoDetailReqDto);
            }
            if (CollectionUtils.isNotEmpty(cargoDetailReqDtos)) {
                FreightForOperatorRespDto freightForOperatorRespDto = this.freightChargeService.directToOperator(cargoDetailReqDtos);
                packageEo.setFreight(freightForOperatorRespDto.getFreight());
                if (freightForOperatorRespDto.getSpec() != null) {
                    packageEo.setSpec(freightForOperatorRespDto.getSpec().stripTrailingZeros().toString());
                } else {
                    packageEo.setSpec("");
                }
                if (freightForOperatorRespDto.getComputeMode() != null) {
                    packageEo.setComputeMode(freightForOperatorRespDto.getComputeMode());
                } else {
                    packageEo.setComputeMode("");
                }
            } else {
                packageEo.setSpec("");
                packageEo.setComputeMode("");
            }
            this.packageDas.insert((BaseEo)packageEo);
            Long packageId = packageEo.getId();
            ArrayList<PackageDetailEo> insertList = new ArrayList<PackageDetailEo>();
            ArrayList packageDetailRespDtos = new ArrayList();
            for (DeliveryOrderDetailVo deliveryOrderDetailVo : deliveryOrderDetailVos1) {
                PackageDetailEo packageDetailEo = new PackageDetailEo();
                packageDetailEo.setPackageId(packageId);
                packageDetailEo.setInstanceId(packageEo.getInstanceId());
                packageDetailEo.setTenantId(packageEo.getTenantId());
                packageDetailEo.setPackageNo(packageEo.getPackageNo());
                packageDetailEo.setCargoId(deliveryOrderDetailVo.getCargoId());
                packageDetailEo.setNum(deliveryOrderDetailVo.getNum());
                insertList.add(packageDetailEo);
            }
            this.packageDetailDas.insertBatch(insertList);
            BeanUtils.copyProperties((Object)packageEo, (Object)packageRespDto);
            DtoHelper.eoList2DtoList(insertList, packageDetailRespDtos, PackageDetailDto.class);
            packageRespDto.setPackageDetailDtos(packageDetailRespDtos);
            packageRespDtos.add(packageRespDto);
        }
        this.logger.info("\u8ba2\u5355[" + deliveryOrderMessageVo.getOrderNo() + "]\u62c6\u5355\u5b8c\u6bd5");
        this.logger.info("\u53d1\u8d27\u5355[" + deliveryOrderMessageVo.getDeliveryOrderNo() + "]\u62c6\u5355\u5b8c\u6bd5");
        return packageRespDtos;
    }

    private String getCode() {
        String s = String.valueOf(IdGenrator.nextId((long)this.workerId, (long)ServiceContext.getContext().getRequestTenantCode()));
        return "pk" + s;
    }
}

