/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.shipping.biz.service.impl;

import com.dtyunxi.cube.commons.channel.ChannelSelector;
import com.dtyunxi.cube.commons.channel.shipping.IShippingChannel;
import com.dtyunxi.cube.commons.channel.shipping.beans.ShippingInfo;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.response.ShippingPartnerCompanyDetailRespDto;
import com.dtyunxi.yundt.cube.center.shipping.biz.service.IQueryShippingService;
import com.dtyunxi.yundt.cube.center.shipping.biz.service.IShippingPartnerCompanyService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class QueryShippingServiceImpl
implements IQueryShippingService {
    private final Logger logger = LoggerFactory.getLogger(QueryShippingServiceImpl.class);
    @Resource
    ChannelSelector<IShippingChannel> channelChannelSelector;
    @Resource
    IShippingPartnerCompanyService shippingPartnerCompanyService;

    @Override
    public ShippingInfo queryShipping(Long shippingCompanyId, String shippingNo) {
        ShippingPartnerCompanyDetailRespDto shippingPartnerRespDto = this.shippingPartnerCompanyService.queryEnable(shippingCompanyId);
        if (shippingPartnerRespDto != null) {
            IShippingChannel shippingChannel = (IShippingChannel)this.channelChannelSelector.select(shippingPartnerRespDto.getShippingPartnerRespDto().getCode());
            ShippingInfo shippingInfo = null;
            try {
                shippingInfo = shippingChannel.queryShipping(shippingNo, shippingPartnerRespDto.getPartnerShippingCode());
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                throw new BizException("\u6e20\u9053\u67e5\u8be2\u51fa\u9519");
            }
            return shippingInfo;
        }
        return null;
    }
}

