/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.shipping.biz.service.impl;

import com.dtyunxi.cube.commons.exceptions.CubeException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.inventory.api.exception.InventoryExceptionCode;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.ServiceAreaDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.ServiceAreaEo;
import com.dtyunxi.yundt.cube.center.shipping.biz.service.IRTemplateAreaService;
import com.dtyunxi.yundt.cube.center.shipping.dao.das.RTemplateAreaDas;
import com.dtyunxi.yundt.cube.center.shipping.dao.das.ShippingTemplateDas;
import com.dtyunxi.yundt.cube.center.shipping.dao.eo.RTemplateAreaEo;
import com.dtyunxi.yundt.cube.center.shipping.dao.eo.ShippingTemplateEo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RTemplateAreaServiceImpl
implements IRTemplateAreaService {
    private static final Logger logger = LoggerFactory.getLogger(RTemplateAreaServiceImpl.class);
    @Resource
    private RTemplateAreaDas rTemplateAreaDas;
    @Resource
    private ShippingTemplateDas shippingTemplateDas;
    @Resource
    private ServiceAreaDas serviceAreaDas;

    @Override
    public Long addRTemplateArea(RTemplateAreaEo rTemplateAreaEo) {
        ShippingTemplateEo shippingTemplateEo = (ShippingTemplateEo)this.shippingTemplateDas.selectByPrimaryKey(rTemplateAreaEo.getShippingTplId());
        if (null == shippingTemplateEo) {
            logger.error(InventoryExceptionCode.TEMPLATE_NOT_EXIST.getCode(), (Object)InventoryExceptionCode.TEMPLATE_NOT_EXIST.getMsg());
            throw new CubeException(InventoryExceptionCode.TEMPLATE_NOT_EXIST.getCode(), InventoryExceptionCode.TEMPLATE_NOT_EXIST.getMsg());
        }
        ServiceAreaEo serviceAreaEo = (ServiceAreaEo)this.serviceAreaDas.selectByPrimaryKey(rTemplateAreaEo.getServiceAreaId());
        if (null == serviceAreaEo) {
            logger.error(InventoryExceptionCode.SERVICE_AREA_NOT_EXIST.getCode(), (Object)InventoryExceptionCode.SERVICE_AREA_NOT_EXIST.getMsg());
            throw new CubeException(InventoryExceptionCode.SERVICE_AREA_NOT_EXIST.getCode(), InventoryExceptionCode.SERVICE_AREA_NOT_EXIST.getMsg());
        }
        this.rTemplateAreaDas.insert((BaseEo)rTemplateAreaEo);
        return rTemplateAreaEo.getId();
    }

    @Override
    public void removeByIds(List<Long> ids) {
        RTemplateAreaEo rTemplateAreaEo = new RTemplateAreaEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"id", ids));
        rTemplateAreaEo.setSqlFilters(sqlFilters);
        this.rTemplateAreaDas.delete((BaseEo)rTemplateAreaEo);
    }

    @Override
    public void removeByShippingTplId(Long shippingTplId) {
        RTemplateAreaEo rTemplateAreaEo = new RTemplateAreaEo();
        rTemplateAreaEo.setShippingTplId(shippingTplId);
        this.rTemplateAreaDas.delete((BaseEo)rTemplateAreaEo);
    }

    @Override
    public RTemplateAreaEo queryById(Long id) {
        RTemplateAreaEo rTemplateAreaEo = (RTemplateAreaEo)this.rTemplateAreaDas.selectByPrimaryKey(id);
        if (null == rTemplateAreaEo) {
            throw new CubeException(InventoryExceptionCode.RECORD_NOT_EXIST.getCode(), InventoryExceptionCode.RECORD_NOT_EXIST.getMsg());
        }
        return rTemplateAreaEo;
    }

    @Override
    public PageInfo<RTemplateAreaEo> queryByPage(RTemplateAreaEo rTemplateAreaEo, Integer pageNum, Integer pageSize) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        return this.rTemplateAreaDas.selectPage((BaseEo)rTemplateAreaEo, pageNum, pageSize);
    }
}

