/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.shipping.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.CubeException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.api.exception.InventoryExceptionCode;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.response.ShippingCompanyRespDto;
import com.dtyunxi.yundt.cube.center.shipping.biz.service.IShippingCompanyService;
import com.dtyunxi.yundt.cube.center.shipping.dao.das.ShippingCompanyDas;
import com.dtyunxi.yundt.cube.center.shipping.dao.eo.ShippingCompanyEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ShippingCompanyServiceImpl
implements IShippingCompanyService {
    private static final Logger logger = LoggerFactory.getLogger(ShippingCompanyServiceImpl.class);
    @Resource
    private ShippingCompanyDas shippingCompanyDas;

    @Override
    public Long addShippingCompany(ShippingCompanyEo shippingCompanyEo) {
        ShippingCompanyEo eo = new ShippingCompanyEo();
        eo.setCode(shippingCompanyEo.getCode());
        List shippingCompanyEos = this.shippingCompanyDas.select((BaseEo)eo);
        if (CollectionUtils.isNotEmpty((Collection)shippingCompanyEos)) {
            logger.error(InventoryExceptionCode.RECORD_DUPLICATED.getCode(), (Object)InventoryExceptionCode.RECORD_DUPLICATED.getMsg());
            throw new CubeException(InventoryExceptionCode.RECORD_DUPLICATED.getCode(), InventoryExceptionCode.RECORD_DUPLICATED.getMsg());
        }
        this.shippingCompanyDas.insert((BaseEo)shippingCompanyEo);
        return shippingCompanyEo.getId();
    }

    @Override
    public void modifyShippingCompany(ShippingCompanyEo shippingCompanyEo) {
        this.shippingCompanyDas.updateSelective((BaseEo)shippingCompanyEo);
    }

    @Override
    public void removeById(Long id) {
        this.shippingCompanyDas.logicDeleteById(id);
    }

    @Override
    public void removeByCode(String code) {
        ShippingCompanyEo shippingCompanyEo = new ShippingCompanyEo();
        shippingCompanyEo.setCode(code);
        ShippingCompanyEo templateEo = (ShippingCompanyEo)this.shippingCompanyDas.selectOne((BaseEo)shippingCompanyEo);
        if (null != templateEo) {
            this.shippingCompanyDas.logicDeleteById(templateEo.getId());
        }
    }

    @Override
    public ShippingCompanyRespDto queryById(Long id) {
        ShippingCompanyEo shippingCompanyEo = (ShippingCompanyEo)this.shippingCompanyDas.selectByPrimaryKey(id);
        if (null == shippingCompanyEo) {
            return null;
        }
        ShippingCompanyRespDto shippingCompanyRespDto = new ShippingCompanyRespDto();
        DtoHelper.eo2Dto((BaseEo)shippingCompanyEo, (BaseVo)shippingCompanyRespDto);
        return shippingCompanyRespDto;
    }

    @Override
    public ShippingCompanyRespDto queryByCode(String code) {
        ShippingCompanyEo shippingCompanyEo = new ShippingCompanyEo();
        shippingCompanyEo.setCode(code);
        ShippingCompanyEo companyEo = (ShippingCompanyEo)this.shippingCompanyDas.selectOne((BaseEo)shippingCompanyEo);
        if (null == shippingCompanyEo) {
            return null;
        }
        ShippingCompanyRespDto shippingCompanyRespDto = new ShippingCompanyRespDto();
        DtoHelper.eo2Dto((BaseEo)companyEo, (BaseVo)shippingCompanyRespDto);
        return shippingCompanyRespDto;
    }

    @Override
    public PageInfo<ShippingCompanyRespDto> queryByPage(ShippingCompanyEo shippingCompanyEo, Integer pageNum, Integer pageSize) {
        PageInfo shippingCompanyEoPageInfo = this.shippingCompanyDas.selectPage((BaseEo)shippingCompanyEo, pageNum, pageSize);
        PageInfo shippingCompanyRespDtoPageInfo = new PageInfo();
        ArrayList shippingCompanyRespDtos = new ArrayList();
        CubeBeanUtils.copyProperties((Object)shippingCompanyRespDtoPageInfo, (Object)shippingCompanyEoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        DtoHelper.eoList2DtoList((Collection)shippingCompanyEoPageInfo.getList(), shippingCompanyRespDtos, ShippingCompanyRespDto.class);
        shippingCompanyRespDtoPageInfo.setList(shippingCompanyRespDtos);
        return shippingCompanyRespDtoPageInfo;
    }
}

