/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.shipping.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.channel.shipping.beans.ShippingInfo;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.biz.util.Assert;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.ShippingLogDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.ShippingLogEo;
import com.dtyunxi.yundt.cube.center.shipping.api.constants.PackageStatusEnum;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.request.PackageDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.response.ShippingLogRespDto;
import com.dtyunxi.yundt.cube.center.shipping.biz.service.IPackageService;
import com.dtyunxi.yundt.cube.center.shipping.biz.service.IQueryShippingService;
import com.dtyunxi.yundt.cube.center.shipping.biz.service.IShippingLogService;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class ShippingLogServiceImpl
implements IShippingLogService {
    @Resource
    private ShippingLogDas shippingLogDas;
    @Resource
    IPackageService packageService;
    @Resource
    private IQueryShippingService queryShippingService;

    @Override
    public ShippingLogRespDto queryLogByShippingNo(String shippingNo, PackageDto packageDto) {
        Boolean overTime;
        ShippingLogRespDto shippingLogRespDto = new ShippingLogRespDto();
        ShippingLogEo eo = this.queryLogNoCheck(shippingNo);
        if (eo != null && !(overTime = Boolean.valueOf(this.isOverTime(eo.getUpdateTime()))).booleanValue()) {
            shippingLogRespDto.setType(Integer.valueOf(1));
            shippingLogRespDto.setTraceLog(eo.getTraceLog());
            shippingLogRespDto.setShippingNo(shippingNo);
            return shippingLogRespDto;
        }
        if (packageDto.getStatus().equals(PackageStatusEnum.SIGNED.getCode()) && eo != null) {
            shippingLogRespDto.setType(Integer.valueOf(1));
            shippingLogRespDto.setTraceLog(eo.getTraceLog());
            shippingLogRespDto.setShippingNo(shippingNo);
            return shippingLogRespDto;
        }
        String log = this.queryByChannel(packageDto);
        shippingLogRespDto.setType(Integer.valueOf(2));
        shippingLogRespDto.setTraceLog(log);
        shippingLogRespDto.setShippingNo(shippingNo);
        return shippingLogRespDto;
    }

    boolean isOverTime(Date updateTime) {
        return DateUtil.addMinutes((Date)new Date(), (int)-60).after(updateTime);
    }

    private String queryByChannel(PackageDto packageDto) {
        ShippingInfo shippingInfo = this.queryShippingService.queryShipping(packageDto.getShippingCompanyId(), packageDto.getShippingNo());
        if (shippingInfo != null) {
            this.updateLogByShippingNo(packageDto.getTenantId(), packageDto.getInstanceId(), shippingInfo.getShippingNo(), JSON.toJSONString((Object)shippingInfo.getTraces()));
            if (shippingInfo.getState().equals("3")) {
                this.packageService.updateStatusById(packageDto.getId(), PackageStatusEnum.SIGNED.getCode());
            }
            return JSON.toJSONString((Object)shippingInfo.getTraces());
        }
        return null;
    }

    @Override
    public String queryLogByShippingNo(String shippingNo) {
        Boolean overTime;
        ShippingLogEo eo = this.queryLogNoCheck(shippingNo);
        if (eo != null && !(overTime = Boolean.valueOf(this.isOverTime(eo.getUpdateTime()))).booleanValue()) {
            return eo.getTraceLog();
        }
        List<PackageDto> packageDtos = this.packageService.queryByShippingNo(shippingNo);
        Assert.isTrue(CollectionUtils.isNotEmpty(packageDtos), "\u8be5\u8fd0\u5355\u5305\u88f9\u4e0d\u5b58\u5728");
        PackageDto packageDto = packageDtos.get(0);
        if (packageDto.getStatus().equals(PackageStatusEnum.SIGNED.getCode())) {
            return eo.getTraceLog();
        }
        return this.queryByChannel(packageDto);
    }

    @Override
    public ShippingLogEo queryLogNoCheck(String shippingNo) {
        ShippingLogEo eo = new ShippingLogEo();
        eo.setShippingNo(shippingNo);
        eo = (ShippingLogEo)this.shippingLogDas.selectOne((BaseEo)eo);
        return eo;
    }

    @Override
    public void updateLogByShippingNo(Long tenantId, Long instanceId, String shippingNo, String log) {
        ShippingLogEo eo = new ShippingLogEo();
        eo.setShippingNo(shippingNo);
        eo.setInstanceId(instanceId);
        eo.setTenantId(tenantId);
        eo = (ShippingLogEo)this.shippingLogDas.selectOne((BaseEo)eo);
        if (eo == null) {
            ShippingLogEo insertLog = new ShippingLogEo();
            insertLog.setShippingNo(shippingNo);
            insertLog.setTraceLog(log);
            insertLog.setInstanceId(instanceId);
            insertLog.setTenantId(tenantId);
            this.shippingLogDas.insert((BaseEo)insertLog);
        } else {
            eo.setTraceLog(log);
            this.shippingLogDas.updateSelective((BaseEo)eo);
        }
    }
}

