/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.shipping.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.shipping.api.constants.PartnerConfigStatusEnum;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.request.ShippingPartnerCompanyModifyReqDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.request.ShippingPartnerCompanyReqDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.response.ShippingPartnerCompanyDetailRespDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.response.ShippingPartnerCompanyRespDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.response.ShippingPartnerRespDto;
import com.dtyunxi.yundt.cube.center.shipping.biz.service.IShippingPartnerCompanyService;
import com.dtyunxi.yundt.cube.center.shipping.biz.service.IShippingPartnerService;
import com.dtyunxi.yundt.cube.center.shipping.dao.das.ShippingCompanyDas;
import com.dtyunxi.yundt.cube.center.shipping.dao.das.ShippingPartnerCompanyDas;
import com.dtyunxi.yundt.cube.center.shipping.dao.eo.ShippingPartnerCompanyEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class ShippingPartnerCompanyServiceImpl
implements IShippingPartnerCompanyService {
    private static final Logger logger = LoggerFactory.getLogger(ShippingPartnerCompanyServiceImpl.class);
    @Resource
    private ShippingPartnerCompanyDas shippingPartnerCompanyDas;
    @Resource
    private IShippingPartnerService shippingPartnerService;
    @Resource
    private ShippingCompanyDas shippingCompanyDas;

    @Override
    public Long add(ShippingPartnerCompanyReqDto shippingPartnerCompanyReqDto) {
        ShippingPartnerCompanyEo shippingPartnerCompanyEo = new ShippingPartnerCompanyEo();
        DtoHelper.dto2Eo((BaseVo)shippingPartnerCompanyReqDto, (BaseEo)shippingPartnerCompanyEo);
        this.shippingPartnerCompanyDas.insert((BaseEo)shippingPartnerCompanyEo);
        return shippingPartnerCompanyEo.getId();
    }

    @Override
    public void modify(ShippingPartnerCompanyModifyReqDto shippingPartnerCompanyReqDto) {
        ShippingPartnerCompanyEo shippingPartnerCompanyEo = new ShippingPartnerCompanyEo();
        DtoHelper.dto2Eo((BaseVo)shippingPartnerCompanyReqDto, (BaseEo)shippingPartnerCompanyEo);
        this.shippingPartnerCompanyDas.update((BaseEo)shippingPartnerCompanyEo);
    }

    @Override
    public List<ShippingPartnerCompanyRespDto> queryList(ShippingPartnerCompanyReqDto shippingPartnerCompanyReqDto) {
        ShippingPartnerCompanyEo shippingPartnerCompanyEo = new ShippingPartnerCompanyEo();
        DtoHelper.dto2Eo((BaseVo)shippingPartnerCompanyReqDto, (BaseEo)shippingPartnerCompanyEo);
        List resultList = this.shippingPartnerCompanyDas.select((BaseEo)shippingPartnerCompanyEo);
        ArrayList<ShippingPartnerCompanyRespDto> shippingPartnerCompanyRespDtos = new ArrayList<ShippingPartnerCompanyRespDto>();
        if (CollectionUtils.isNotEmpty((Collection)resultList)) {
            DtoHelper.eoList2DtoList((Collection)resultList, shippingPartnerCompanyRespDtos, ShippingPartnerCompanyRespDto.class);
        }
        return shippingPartnerCompanyRespDtos;
    }

    @Override
    public PageInfo<ShippingPartnerCompanyRespDto> queryList(ShippingPartnerCompanyReqDto shippingPartnerCompanyReqDto, Integer pageNum, Integer pageSize) {
        ShippingPartnerCompanyEo shippingPartnerCompanyEo = new ShippingPartnerCompanyEo();
        DtoHelper.dto2Eo((BaseVo)shippingPartnerCompanyReqDto, (BaseEo)shippingPartnerCompanyEo);
        PageInfo pageInfo = this.shippingPartnerCompanyDas.selectPage((BaseEo)shippingPartnerCompanyEo, pageNum, pageSize);
        List resultList = pageInfo.getList();
        ArrayList shippingPartnerCompanyRespDtos = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)resultList)) {
            DtoHelper.eoList2DtoList((Collection)resultList, shippingPartnerCompanyRespDtos, ShippingPartnerCompanyRespDto.class);
        }
        PageInfo pageInfoDto = new PageInfo();
        BeanUtils.copyProperties((Object)pageInfo, (Object)pageInfoDto);
        pageInfoDto.setList(shippingPartnerCompanyRespDtos);
        return pageInfoDto;
    }

    @Override
    public ShippingPartnerCompanyRespDto queryById(Long instanceId, Long tenantId, Long id) {
        ShippingPartnerCompanyEo shippingPartnerCompanyEo = new ShippingPartnerCompanyEo();
        shippingPartnerCompanyEo.setId(id);
        shippingPartnerCompanyEo.setInstanceId(instanceId);
        shippingPartnerCompanyEo.setTenantId(tenantId);
        ShippingPartnerCompanyEo result = (ShippingPartnerCompanyEo)this.shippingPartnerCompanyDas.selectOne((BaseEo)shippingPartnerCompanyEo);
        ShippingPartnerCompanyRespDto shippingPartnerCompanyRespDto = new ShippingPartnerCompanyRespDto();
        DtoHelper.eo2Dto((BaseEo)result, (BaseVo)shippingPartnerCompanyRespDto);
        return shippingPartnerCompanyRespDto;
    }

    @Override
    public ShippingPartnerCompanyDetailRespDto queryEnable(Long shippingCompanyId) {
        List<ShippingPartnerCompanyRespDto> shippingPartnerCompanyRespDtos = this.queryEnableList(shippingCompanyId);
        Set<Long> ids = shippingPartnerCompanyRespDtos.stream().map(shippingPartnerCompanyRespDto -> shippingPartnerCompanyRespDto.getShippingPartnerId()).collect(Collectors.toSet());
        List<ShippingPartnerRespDto> shippingPartnerRespDtos = this.shippingPartnerService.queryByEnableIds(ids);
        if (CollectionUtils.isNotEmpty(shippingPartnerRespDtos)) {
            ShippingPartnerRespDto shippingPartnerRespDto = shippingPartnerRespDtos.get(0);
            ShippingPartnerCompanyDetailRespDto shippingPartnerCompanyDetailRespDto = new ShippingPartnerCompanyDetailRespDto();
            List shippingPartnerCompanyRespList = shippingPartnerCompanyRespDtos.stream().filter(o -> o.getShippingPartnerId().equals(shippingPartnerRespDto.getId())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(shippingPartnerCompanyRespList)) {
                return null;
            }
            BeanUtils.copyProperties(shippingPartnerCompanyRespList.get(0), (Object)shippingPartnerCompanyDetailRespDto);
            shippingPartnerCompanyDetailRespDto.setShippingPartnerRespDto(shippingPartnerRespDto);
            return shippingPartnerCompanyDetailRespDto;
        }
        return null;
    }

    @Override
    public void initCompany() {
        List shippingCompanyEos = this.shippingCompanyDas.selectAll();
        shippingCompanyEos.stream().forEach(shippingCompanyEo -> {
            ShippingPartnerCompanyEo shippingPartnerCompanyEo = new ShippingPartnerCompanyEo();
            shippingPartnerCompanyEo.setStatus(PartnerConfigStatusEnum.ENABLED.getCode());
            shippingPartnerCompanyEo.setShippingPartnerId(Long.valueOf(1192004248448050184L));
            shippingPartnerCompanyEo.setShippingCompanyId(shippingCompanyEo.getId());
            shippingPartnerCompanyEo.setPartnerShippingCode(shippingCompanyEo.getCode());
            shippingPartnerCompanyEo.setShippingCode(shippingCompanyEo.getCode());
            shippingPartnerCompanyEo.setPartnerCode("kidiNiaoShippingChannelImpl");
            shippingPartnerCompanyEo.setInstanceId(Long.valueOf(1L));
            shippingPartnerCompanyEo.setTenantId(Long.valueOf(1L));
            this.shippingPartnerCompanyDas.insert((BaseEo)shippingPartnerCompanyEo);
        });
    }

    @Override
    public List<ShippingPartnerCompanyRespDto> queryEnableList(Long shippingId) {
        ShippingPartnerCompanyEo shippingPartnerCompanyEo = new ShippingPartnerCompanyEo();
        shippingPartnerCompanyEo.setShippingCompanyId(shippingId);
        shippingPartnerCompanyEo.setStatus(PartnerConfigStatusEnum.ENABLED.getCode());
        List resultList = this.shippingPartnerCompanyDas.select((BaseEo)shippingPartnerCompanyEo);
        ArrayList<ShippingPartnerCompanyRespDto> shippingPartnerCompanyRespDtos = new ArrayList<ShippingPartnerCompanyRespDto>();
        if (CollectionUtils.isNotEmpty((Collection)resultList)) {
            DtoHelper.eoList2DtoList((Collection)resultList, shippingPartnerCompanyRespDtos, ShippingPartnerCompanyRespDto.class);
        }
        return shippingPartnerCompanyRespDtos;
    }
}

