/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.shipping.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.shipping.api.constants.PartnerConfigStatusEnum;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.request.ShippingPartnerConfigCreateReqDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.request.ShippingPartnerConfigUpdateReqDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.request.ShippingPartnerCreateReqDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.request.ShippingPartnerUpdateReqDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.response.ShippingPartnerConfigRespDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.response.ShippingPartnerRespDto;
import com.dtyunxi.yundt.cube.center.shipping.biz.service.IShippingPartnerCompanyService;
import com.dtyunxi.yundt.cube.center.shipping.biz.service.IShippingPartnerService;
import com.dtyunxi.yundt.cube.center.shipping.dao.das.ShippingPartnerConfigDas;
import com.dtyunxi.yundt.cube.center.shipping.dao.das.ShippingPartnerDas;
import com.dtyunxi.yundt.cube.center.shipping.dao.eo.ShippingPartnerConfigEo;
import com.dtyunxi.yundt.cube.center.shipping.dao.eo.ShippingPartnerEo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class ShippingPartnerServiceImpl
implements IShippingPartnerService {
    private static final Logger logger = LoggerFactory.getLogger(ShippingPartnerServiceImpl.class);
    @Resource
    ShippingPartnerDas shippingPartnerDas;
    @Resource
    ShippingPartnerConfigDas shippingPartnerConfigDas;
    @Resource
    IShippingPartnerCompanyService shippingPartnerCompanyService;

    @Override
    public void addShippingPartner(ShippingPartnerCreateReqDto shippingPartnerCreateReqDto) {
        ShippingPartnerEo shippingPartnerEo = new ShippingPartnerEo();
        if (null != shippingPartnerCreateReqDto) {
            DtoHelper.dto2Eo((BaseVo)shippingPartnerCreateReqDto, (BaseEo)shippingPartnerEo);
        }
        this.shippingPartnerDas.insert((BaseEo)shippingPartnerEo);
    }

    @Override
    public ShippingPartnerConfigRespDto getByKuaiDiNiao() {
        ShippingPartnerEo shippingPartnerEo = new ShippingPartnerEo();
        shippingPartnerEo.setCode("0001");
        shippingPartnerEo.setStatus("enable");
        ShippingPartnerEo result = (ShippingPartnerEo)this.shippingPartnerDas.selectOne((BaseEo)shippingPartnerEo);
        ShippingPartnerConfigEo shippingPartnerConfigEo = new ShippingPartnerConfigEo();
        shippingPartnerConfigEo.setPartnerId(result.getId());
        shippingPartnerConfigEo.setStatus("enable");
        ShippingPartnerConfigEo configResult = (ShippingPartnerConfigEo)this.shippingPartnerConfigDas.selectOne((BaseEo)shippingPartnerConfigEo);
        ShippingPartnerConfigRespDto shippingPartnerConfigRespDto = new ShippingPartnerConfigRespDto();
        BeanUtils.copyProperties((Object)configResult, (Object)shippingPartnerConfigRespDto);
        return shippingPartnerConfigRespDto;
    }

    @Override
    public void modifyShippingPartner(Long id, ShippingPartnerUpdateReqDto shippingPartnerUpdateReqDto) {
        ShippingPartnerEo shippingPartnerEo = new ShippingPartnerEo();
        if (null != shippingPartnerUpdateReqDto) {
            DtoHelper.dto2Eo((BaseVo)shippingPartnerUpdateReqDto, (BaseEo)shippingPartnerEo);
        }
        shippingPartnerEo.setId(id);
        this.shippingPartnerDas.updateSelective((BaseEo)shippingPartnerEo);
    }

    @Override
    public void removeById(Long id) {
        this.shippingPartnerDas.logicDeleteById(id);
        ShippingPartnerConfigEo shippingPartnerConfigEo = new ShippingPartnerConfigEo();
        shippingPartnerConfigEo.setPartnerId(id);
        List shippingPartnerConfigEos = this.shippingPartnerConfigDas.select((BaseEo)shippingPartnerConfigEo);
        for (ShippingPartnerConfigEo configEo : shippingPartnerConfigEos) {
            this.shippingPartnerConfigDas.logicDeleteById(configEo.getId());
        }
    }

    @Override
    public ShippingPartnerRespDto getById(Long id) {
        ShippingPartnerEo shippingPartnerEo = (ShippingPartnerEo)this.shippingPartnerDas.selectByPrimaryKey(id);
        ShippingPartnerRespDto shippingPartnerRespDto = new ShippingPartnerRespDto();
        if (null != shippingPartnerEo) {
            DtoHelper.eo2Dto((BaseEo)shippingPartnerEo, (BaseVo)shippingPartnerRespDto);
        }
        return shippingPartnerRespDto;
    }

    @Override
    public void addShippingPartnerConfig(ShippingPartnerConfigCreateReqDto shippingPartnerConfigCreateReqDto) {
        ShippingPartnerConfigEo shippingPartnerConfigEo = new ShippingPartnerConfigEo();
        if (null != shippingPartnerConfigCreateReqDto) {
            DtoHelper.dto2Eo((BaseVo)shippingPartnerConfigCreateReqDto, (BaseEo)shippingPartnerConfigEo);
        }
        this.shippingPartnerConfigDas.insert((BaseEo)shippingPartnerConfigEo);
    }

    @Override
    public void modifyShippingPartnerConfig(Long id, ShippingPartnerConfigUpdateReqDto shippingPartnerConfigUpdateReqDto) {
        ShippingPartnerConfigEo shippingPartnerConfigEo = new ShippingPartnerConfigEo();
        if (null != shippingPartnerConfigUpdateReqDto) {
            DtoHelper.dto2Eo((BaseVo)shippingPartnerConfigUpdateReqDto, (BaseEo)shippingPartnerConfigEo);
        }
        shippingPartnerConfigEo.setId(id);
        this.shippingPartnerConfigDas.updateSelective((BaseEo)shippingPartnerConfigEo);
    }

    @Override
    public void removeConfigById(Long id) {
        this.shippingPartnerConfigDas.logicDeleteById(id);
    }

    @Override
    public ShippingPartnerConfigRespDto getConfigById(Long id) {
        ShippingPartnerConfigEo shippingPartnerConfigEo = (ShippingPartnerConfigEo)this.shippingPartnerConfigDas.selectByPrimaryKey(id);
        ShippingPartnerConfigRespDto shippingPartnerConfigRespDto = new ShippingPartnerConfigRespDto();
        if (null != shippingPartnerConfigEo) {
            DtoHelper.eo2Dto((BaseEo)shippingPartnerConfigEo, (BaseVo)shippingPartnerConfigRespDto);
        }
        return shippingPartnerConfigRespDto;
    }

    @Override
    public List<ShippingPartnerRespDto> queryByEnableIds(Set<Long> ids) {
        ShippingPartnerEo shippingPartnerEo = new ShippingPartnerEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"id", (Object)StringUtils.join(ids, (String)",")));
        shippingPartnerEo.setSqlFilters(sqlFilters);
        shippingPartnerEo.setStatus(PartnerConfigStatusEnum.ENABLED.getCode());
        List shippingPartnerEos = this.shippingPartnerDas.select((BaseEo)shippingPartnerEo);
        if (CollectionUtils.isNotEmpty((Collection)shippingPartnerEos)) {
            ArrayList<ShippingPartnerRespDto> shippingPartnerRespDtos = new ArrayList<ShippingPartnerRespDto>();
            DtoHelper.eoList2DtoList((Collection)shippingPartnerEos, shippingPartnerRespDtos, ShippingPartnerRespDto.class);
            return shippingPartnerRespDtos;
        }
        return null;
    }
}

