/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.shipping.biz.service.impl;

import com.dtyunxi.cube.commons.exceptions.CubeException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.inventory.api.exception.InventoryExceptionCode;
import com.dtyunxi.yundt.cube.center.shipping.biz.service.IShippingRuleService;
import com.dtyunxi.yundt.cube.center.shipping.dao.das.ShippingRuleDas;
import com.dtyunxi.yundt.cube.center.shipping.dao.eo.ShippingRuleEo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ShippingRuleServiceImpl
implements IShippingRuleService {
    private static final Logger logger = LoggerFactory.getLogger(ShippingRuleServiceImpl.class);
    @Resource
    private ShippingRuleDas shippingRuleDas;

    @Override
    public void addShippingRule(ShippingRuleEo shippingRuleEo) {
        List shippingRuleEos = this.shippingRuleDas.select((BaseEo)shippingRuleEo);
        if (!CollectionUtils.isEmpty((Collection)shippingRuleEos)) {
            logger.error(InventoryExceptionCode.RECORD_DUPLICATED.getCode(), (Object)InventoryExceptionCode.RECORD_DUPLICATED.getMsg());
            throw new CubeException(InventoryExceptionCode.RECORD_DUPLICATED.getCode(), InventoryExceptionCode.RECORD_DUPLICATED.getMsg());
        }
        this.shippingRuleDas.insert((BaseEo)shippingRuleEo);
    }

    @Override
    public void modifyShippingRule(ShippingRuleEo shippingRuleEo) {
        this.shippingRuleDas.updateSelective((BaseEo)shippingRuleEo);
    }

    @Override
    public void removeByIds(List<Long> ids) {
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"id", ids));
        ShippingRuleEo shippingRuleEo = new ShippingRuleEo();
        shippingRuleEo.setSqlFilters(sqlFilters);
        this.shippingRuleDas.logicDeleteByExample((BaseEo)shippingRuleEo);
    }

    @Override
    public void removeByShippingTplId(Long shippingTplId) {
        ShippingRuleEo shippingRuleEo = new ShippingRuleEo();
        shippingRuleEo.setShippingTplId(shippingTplId);
        this.shippingRuleDas.logicDeleteByExample((BaseEo)shippingRuleEo);
    }

    @Override
    public ShippingRuleEo queryById(Long id) {
        ShippingRuleEo shippingRuleEo = (ShippingRuleEo)this.shippingRuleDas.selectByPrimaryKey(id);
        if (null == shippingRuleEo) {
            throw new CubeException(InventoryExceptionCode.RECORD_NOT_EXIST.getCode(), InventoryExceptionCode.RECORD_NOT_EXIST.getMsg());
        }
        return shippingRuleEo;
    }

    @Override
    public ShippingRuleEo queryByShippingTplId(Long shippingTplId) {
        ShippingRuleEo shippingRuleEo = new ShippingRuleEo();
        shippingRuleEo.setShippingTplId(shippingTplId);
        return (ShippingRuleEo)this.shippingRuleDas.selectOne((BaseEo)shippingRuleEo);
    }
}

