/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.shipping.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.commons.exceptions.CubeException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.api.exception.InventoryExceptionCode;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.response.ShippingRuleRespDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.response.ShippingTemplateRespDto;
import com.dtyunxi.yundt.cube.center.shipping.biz.service.IShippingRuleService;
import com.dtyunxi.yundt.cube.center.shipping.biz.service.IShippingTemplateService;
import com.dtyunxi.yundt.cube.center.shipping.dao.das.RTemplateAreaDas;
import com.dtyunxi.yundt.cube.center.shipping.dao.das.ShippingRuleDas;
import com.dtyunxi.yundt.cube.center.shipping.dao.das.ShippingTemplateDas;
import com.dtyunxi.yundt.cube.center.shipping.dao.eo.RTemplateAreaEo;
import com.dtyunxi.yundt.cube.center.shipping.dao.eo.ShippingRuleEo;
import com.dtyunxi.yundt.cube.center.shipping.dao.eo.ShippingTemplateEo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ShippingTemplateServiceImpl
implements IShippingTemplateService {
    private static final Logger logger = LoggerFactory.getLogger(ShippingTemplateServiceImpl.class);
    @Resource
    private ShippingTemplateDas shippingTemplateDas;
    @Resource
    private RTemplateAreaDas rTemplateAreaDas;
    @Resource
    private ShippingRuleDas shippingRuleDas;
    @Resource
    private IShippingRuleService shippingRuleService;

    @Override
    public Long addShippingTemplate(ShippingTemplateEo shippingTemplateEo) {
        ShippingTemplateEo eo = new ShippingTemplateEo();
        eo.setCode(shippingTemplateEo.getCode());
        List shippingTemplateEos = this.shippingTemplateDas.select((BaseEo)eo);
        if (CollectionUtils.isNotEmpty((Collection)shippingTemplateEos)) {
            logger.error(InventoryExceptionCode.CODE_DUPLICATED.getCode(), (Object)InventoryExceptionCode.CODE_DUPLICATED.getMsg());
            throw new BizException(InventoryExceptionCode.CODE_DUPLICATED.getCode(), InventoryExceptionCode.CODE_DUPLICATED.getMsg());
        }
        this.shippingTemplateDas.insert((BaseEo)shippingTemplateEo);
        return shippingTemplateEo.getId();
    }

    @Override
    public void modifyShippingTemplate(ShippingTemplateEo shippingTemplateEo) {
        this.shippingTemplateDas.updateSelective((BaseEo)shippingTemplateEo);
    }

    @Override
    public void removeById(Long id) {
        this.shippingTemplateDas.logicDeleteById(id);
        RTemplateAreaEo rTemplateAreaEo = new RTemplateAreaEo();
        rTemplateAreaEo.setShippingTplId(id);
        this.rTemplateAreaDas.delete((BaseEo)rTemplateAreaEo);
        ShippingRuleEo ruleEo = this.shippingRuleService.queryByShippingTplId(id);
        ShippingRuleEo shippingRuleEo = new ShippingRuleEo();
        if (null != ruleEo) {
            this.shippingRuleDas.logicDeleteById(ruleEo.getId());
        }
    }

    @Override
    public void removeByCode(String code) {
        ShippingTemplateEo shippingTemplateEo = new ShippingTemplateEo();
        shippingTemplateEo.setCode(code);
        ShippingTemplateEo templateEo = (ShippingTemplateEo)this.shippingTemplateDas.selectOne((BaseEo)shippingTemplateEo);
        if (null != templateEo) {
            this.shippingTemplateDas.logicDeleteById(templateEo.getId());
            Long id = templateEo.getId();
            RTemplateAreaEo rTemplateAreaEo = new RTemplateAreaEo();
            rTemplateAreaEo.setShippingTplId(id);
            this.rTemplateAreaDas.delete((BaseEo)rTemplateAreaEo);
            ShippingRuleEo ruleEo = this.shippingRuleService.queryByShippingTplId(id);
            ShippingRuleEo shippingRuleEo = new ShippingRuleEo();
            if (null != ruleEo) {
                this.shippingRuleDas.logicDeleteById(ruleEo.getId());
            }
        }
    }

    @Override
    public ShippingTemplateRespDto queryById(Long id) {
        ShippingTemplateRespDto shippingTemplateRespDto = new ShippingTemplateRespDto();
        ShippingTemplateEo shippingTemplateEo = (ShippingTemplateEo)this.shippingTemplateDas.selectByPrimaryKey(id);
        if (null == shippingTemplateEo) {
            throw new BusinessRuntimeException(InventoryExceptionCode.RECORD_NOT_EXIST.getCode(), InventoryExceptionCode.RECORD_NOT_EXIST.getMsg());
        }
        ShippingRuleEo shippingRuleEo = new ShippingRuleEo();
        shippingRuleEo.setShippingTplId(id);
        ShippingRuleEo ruleEo = (ShippingRuleEo)this.shippingRuleDas.selectOne((BaseEo)shippingRuleEo);
        if (null == ruleEo) {
            throw new BusinessRuntimeException(InventoryExceptionCode.RECORD_NOT_EXIST.getCode(), InventoryExceptionCode.RECORD_NOT_EXIST.getMsg());
        }
        ShippingRuleRespDto shippingRuleRespDto = new ShippingRuleRespDto();
        DtoHelper.eo2Dto((BaseEo)shippingTemplateEo, (BaseVo)shippingTemplateRespDto);
        DtoHelper.eo2Dto((BaseEo)ruleEo, (BaseVo)shippingTemplateRespDto, (String[])new String[]{"id"});
        return shippingTemplateRespDto;
    }

    @Override
    public ShippingTemplateRespDto queryByCode(String code) {
        ShippingTemplateRespDto shippingTemplateRespDto = new ShippingTemplateRespDto();
        ShippingTemplateEo shippingTemplateEo = new ShippingTemplateEo();
        shippingTemplateEo.setCode(code);
        ShippingTemplateEo templateEo = (ShippingTemplateEo)this.shippingTemplateDas.selectOne((BaseEo)shippingTemplateEo);
        if (null == templateEo) {
            throw new CubeException(InventoryExceptionCode.RECORD_NOT_EXIST.getCode(), InventoryExceptionCode.RECORD_NOT_EXIST.getMsg());
        }
        ShippingRuleEo shippingRuleEo = new ShippingRuleEo();
        shippingRuleEo.setShippingTplId(templateEo.getId());
        ShippingRuleEo ruleEo = (ShippingRuleEo)this.shippingRuleDas.selectOne((BaseEo)shippingRuleEo);
        if (null == ruleEo) {
            throw new CubeException(InventoryExceptionCode.RECORD_NOT_EXIST.getCode(), InventoryExceptionCode.RECORD_NOT_EXIST.getMsg());
        }
        DtoHelper.eo2Dto((BaseEo)templateEo, (BaseVo)shippingTemplateRespDto);
        DtoHelper.eo2Dto((BaseEo)ruleEo, (BaseVo)shippingTemplateRespDto, (String[])new String[]{"id"});
        return shippingTemplateRespDto;
    }

    @Override
    public List<ShippingTemplateRespDto> queryByServiceAreaId(Long serviceAreaId) {
        List templateAndRuleVos = this.shippingRuleDas.selectByServiceAreaId(serviceAreaId);
        ArrayList<ShippingTemplateRespDto> shippingTemplateRespDtos = new ArrayList<ShippingTemplateRespDto>();
        CubeBeanUtils.copyCollection(shippingTemplateRespDtos, (Collection)templateAndRuleVos, ShippingTemplateRespDto.class);
        return shippingTemplateRespDtos;
    }

    @Override
    public List<ShippingTemplateRespDto> queryByGroupId(Long groupId) {
        ShippingTemplateEo shippingTemplateEo = new ShippingTemplateEo();
        shippingTemplateEo.setGroupId(groupId);
        List templateAndRuleVos = this.shippingRuleDas.selectByGroupId(groupId);
        ArrayList<ShippingTemplateRespDto> shippingTemplateRespDtos = new ArrayList<ShippingTemplateRespDto>();
        CubeBeanUtils.copyCollection(shippingTemplateRespDtos, (Collection)templateAndRuleVos, ShippingTemplateRespDto.class);
        return shippingTemplateRespDtos;
    }

    @Override
    public PageInfo<ShippingTemplateRespDto> queryByPage(ShippingTemplateEo shippingTemplateEo, Integer pageNum, Integer pageSize) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        PageInfo pageInfo = this.shippingTemplateDas.selectPage((BaseEo)shippingTemplateEo, pageNum, pageSize);
        PageInfo respDtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)respDtoPageInfo, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        if (CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            return respDtoPageInfo;
        }
        List ids = this.shippingTemplateDas.getIds(pageInfo.getList());
        List templateAndRuleVos = this.shippingRuleDas.selectByShippingTplIds(ids);
        ArrayList respDtos = new ArrayList();
        CubeBeanUtils.copyCollection(respDtos, (Collection)templateAndRuleVos, ShippingTemplateRespDto.class);
        respDtoPageInfo.setList(respDtos);
        return respDtoPageInfo;
    }
}

