/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.scheduler.biz.apiimpl;

import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.scheduler.api.ITaskInstApi;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.response.TaskInstQueryRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.biz.service.ITaskInstService;
import com.dtyunxi.yundt.cube.center.scheduler.biz.task.RetryTaskExecutor;
import com.dtyunxi.yundt.cube.center.scheduler.biz.task.TaskExecutor;
import com.dtyunxi.yundt.cube.center.scheduler.biz.vo.RetryVo;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="taskInstApi")
public class TaskInstApiImpl
implements ITaskInstApi {
    private static final Logger logger = LoggerFactory.getLogger(TaskInstApiImpl.class);
    @Resource(name="cubeSchedulerTaskExecutor")
    private TaskExecutor taskExecutor;
    @Resource
    private RetryTaskExecutor retryTaskExecutor;
    @Resource
    private ILockService lockService;
    @Autowired
    private ITaskInstService taskInstService;

    public RestResponse<Long> add(Long taskId, RequestDto requestDto) {
        try {
            return this.taskExecutor.execute(taskId, null, taskId, null);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            throw new BusinessRuntimeException("10001", "\u624b\u52a8\u89e6\u53d1\u4efb\u52a1\u5931\u8d25");
        }
    }

    public RestResponse<Void> retry(Long id) {
        TaskInstQueryRespDto taskInstDto = this.taskInstService.queryById(id);
        Mutex mutex = null;
        try {
            mutex = this.lockService.lock("task_inst", "" + id, 3, 3, TimeUnit.SECONDS);
            RetryVo retryVo = new RetryVo(id, null, 2);
            this.retryTaskExecutor.execute(retryVo);
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                this.lockService.unlock(mutex);
                throw throwable;
            }
        }
        this.lockService.unlock(mutex);
        return RestResponse.VOID;
    }
}

