/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.scheduler.biz.apiimpl;

import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.scheduler.api.ITaskInstShardApi;
import com.dtyunxi.yundt.cube.center.scheduler.biz.service.ITaskInstShardService;
import com.dtyunxi.yundt.cube.center.scheduler.biz.task.RetryTaskExecutor;
import com.dtyunxi.yundt.cube.center.scheduler.biz.vo.RetryVo;
import com.dtyunxi.yundt.cube.center.scheduler.dao.eo.TaskInstShardEo;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="taskInstShardApi")
public class TaskInstShardApiImpl
implements ITaskInstShardApi {
    @Resource
    private RetryTaskExecutor retryTaskExecutor;
    @Resource
    private ILockService lockService;
    @Autowired
    private ITaskInstShardService taskInstShardService;

    public RestResponse<Void> retry(Long id) {
        TaskInstShardEo taskInstShardEo = this.taskInstShardService.selectById(id);
        if (taskInstShardEo == null) {
            throw new BusinessRuntimeException("11002", "\u4efb\u52a1\u5b9e\u4f8b\u5206\u7247\u4e0d\u5b58\u5728 | taskInstShardId = " + id);
        }
        Mutex mutex = null;
        try {
            mutex = this.lockService.lock("task_inst_shard", "" + id, 3, 3, TimeUnit.SECONDS);
            RetryVo retryVo = new RetryVo(id, id, 2);
            this.retryTaskExecutor.execute(retryVo);
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                this.lockService.unlock(mutex);
                throw throwable;
            }
        }
        this.lockService.unlock(mutex);
        return RestResponse.VOID;
    }
}

