/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.scheduler.biz.apiimpl.query;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskInstShardReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.response.TaskInstShardRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.query.ITaskInstShardQueryApi;
import com.dtyunxi.yundt.cube.center.scheduler.biz.service.ITaskInstShardService;
import com.dtyunxi.yundt.cube.center.scheduler.common.constants.TaskInstShardStatusEnum;
import com.dtyunxi.yundt.cube.center.scheduler.dao.eo.TaskInstShardEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="taskInstShardQueryApi")
public class TaskInstShardQueryApiImpl
implements ITaskInstShardQueryApi {
    @Autowired
    ITaskInstShardService taskInstShardService;

    public RestResponse<TaskInstShardRespDto> queryById(Long id, String filter) {
        TaskInstShardEo eo = this.taskInstShardService.selectById(id);
        if (null == eo) {
            throw new BusinessRuntimeException("11002", "\u4e3b\u952eID\u4e0d\u5b58\u5728\uff0c\u4e3b\u952eID=" + id);
        }
        TaskInstShardRespDto respDto = new TaskInstShardRespDto();
        DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)respDto);
        return new RestResponse((Object)respDto);
    }

    public RestResponse<List<TaskInstShardRespDto>> queryByTaskId(Long taskId, String filter) {
        TaskInstShardEo eo = new TaskInstShardEo();
        eo.setTaskId(taskId);
        List<TaskInstShardEo> eoList = this.taskInstShardService.queryByEo(eo);
        if (CollectionUtils.isEmpty(eoList)) {
            throw new BusinessRuntimeException("11002", "\u4efb\u52a1id\u4e0d\u5b58\u5728\uff0c\u4efb\u52a1id=" + taskId);
        }
        ArrayList respDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList(eoList, (Collection)respDtoList, TaskInstShardRespDto.class);
        return new RestResponse((Object)respDtoList);
    }

    public RestResponse<PageInfo<TaskInstShardRespDto>> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        TaskInstShardReqDto reqDto = (TaskInstShardReqDto)JSON.parseObject((String)filter, TaskInstShardReqDto.class);
        TaskInstShardEo eo = new TaskInstShardEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)eo);
        PageInfo<TaskInstShardEo> eoPageInfo = this.taskInstShardService.queryByPage(eo, pageNum, pageSize);
        ArrayList list = Lists.newArrayList();
        PageInfo pageInfo = new PageInfo((List)list);
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), (Collection)list, TaskInstShardRespDto.class);
        CubeBeanUtils.copyProperties((Object)pageInfo, eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            for (TaskInstShardRespDto dto : pageInfo.getList()) {
                if (TaskInstShardStatusEnum.RUNNING.getCode().equals(dto.getStatus())) {
                    DateUtil.getTimeDiff((Date)dto.getCreateTime(), (Date)new Date());
                    continue;
                }
                dto.setRunningTime(DateUtil.getTimeDiff((Date)dto.getCreateTime(), (Date)dto.getUpdateTime()));
            }
        }
        return new RestResponse((Object)pageInfo);
    }
}

