/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.scheduler.biz.quartz.job;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.yundt.cube.center.scheduler.biz.quartz.job.JobInfo;
import com.dtyunxi.yundt.cube.center.scheduler.biz.task.RetryTaskExecutor;
import com.dtyunxi.yundt.cube.center.scheduler.biz.vo.RetryVo;
import javax.annotation.Resource;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AutoRetryJob
implements Job {
    private static final Logger logger = LoggerFactory.getLogger(AutoRetryJob.class);
    @Resource
    RetryTaskExecutor retryTaskExecutor;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            JobInfo jobInfo = this.getJobInfo(context);
            logger.info("\u4efb\u52a1\u5b9a\u65f6\u89e6\u53d1 | " + JSON.toJSONString((Object)jobInfo));
            String jobName = jobInfo.getJobName();
            String[] ids = jobName.split(",");
            Long taskInstId = Long.valueOf(ids[1]);
            Long taskInstShardId = Long.valueOf(jobInfo.getJobGroup());
            if (taskInstId.equals(taskInstShardId)) {
                taskInstShardId = null;
            }
            RetryVo retryVo = new RetryVo(jobInfo.getInstanceName(), taskInstId, taskInstShardId, 1);
            this.retryTaskExecutor.execute(retryVo);
        }
        catch (Exception e) {
            logger.error("\u5b9a\u65f6\u89e6\u53d1\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
    }

    private JobInfo getJobInfo(JobExecutionContext context) throws SchedulerException {
        JobInfo jobInfo = new JobInfo();
        CronTrigger trigger = (CronTrigger)context.getTrigger();
        jobInfo.setJobName(trigger.getKey().getName());
        jobInfo.setJobGroup(trigger.getKey().getGroup());
        jobInfo.setInstanceName(context.getScheduler().getSchedulerName());
        return jobInfo;
    }
}

