/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.scheduler.biz.quartz.job;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.yundt.cube.center.scheduler.biz.quartz.job.JobInfo;
import com.dtyunxi.yundt.cube.center.scheduler.biz.task.TaskExecutor;
import javax.annotation.Resource;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CommonSingleJob
implements Job {
    private static final Logger logger = LoggerFactory.getLogger(CommonSingleJob.class);
    @Resource(name="cubeSchedulerTaskExecutor")
    private TaskExecutor taskExecutor;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            JobInfo jobInfo = this.getJobInfo(context);
            logger.info("\u4efb\u52a1\u5b9a\u65f6\u89e6\u53d1 | " + JSON.toJSONString((Object)jobInfo));
            Long taskId = Long.valueOf(jobInfo.getJobName());
            Long taskBatchId = Long.valueOf(jobInfo.getJobGroup());
            this.taskExecutor.execute(taskId, jobInfo.getInstanceName(), taskBatchId, null);
        }
        catch (Exception e) {
            logger.error("\u5b9a\u65f6\u89e6\u53d1\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
    }

    private JobInfo getJobInfo(JobExecutionContext context) throws SchedulerException {
        JobInfo jobInfo = new JobInfo();
        CronTrigger trigger = (CronTrigger)context.getTrigger();
        jobInfo.setCronExpression(trigger.getCronExpression());
        jobInfo.setJobName(trigger.getKey().getName());
        jobInfo.setJobGroup(trigger.getKey().getGroup());
        jobInfo.setClassName(trigger.getKey().getClass().getSimpleName());
        jobInfo.setInstanceId(context.getScheduler().getSchedulerInstanceId());
        jobInfo.setInstanceName(context.getScheduler().getSchedulerName());
        return jobInfo;
    }
}

