/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.scheduler.biz.quartz.processor;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.HeartMsg;
import java.text.SimpleDateFormat;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class HeartMsgProcessor
implements IMessageProcessor<HeartMsg> {
    private static final Logger logger = LoggerFactory.getLogger(HeartMsgProcessor.class);
    @Resource
    private ICacheService cacheService;
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-DD HH:mm:ss");
    @Value(value="${yundt.cube.center.scheduler.heartbeat.rate:1}")
    private Integer heartRate;

    public MessageResponse process(HeartMsg heartMsg) {
        logger.debug("----------> \u6536\u5230\u5fc3\u8df3 | " + JSON.toJSONString((Object)heartMsg));
        String appCode = heartMsg.getAppCode();
        Long lastTime = heartMsg.getLastTime();
        if (StringUtils.isBlank((CharSequence)appCode)) {
            logger.error("\u5fc3\u8df3\u4fe1\u606f\u7f3a\u5931\uff1aappCode is required");
            return MessageResponse.SUCCESS;
        }
        if (lastTime == null) {
            logger.error("\u5fc3\u8df3\u4fe1\u606f\u7f3a\u5931\uff1alastTime is required");
            return MessageResponse.SUCCESS;
        }
        logger.debug("\u6536\u5230\u5fc3\u8df3\u65f6\u95f4\uff1a " + this.sdf.format(lastTime));
        long currentTimeMillis = System.currentTimeMillis();
        int heartBeatAliveSecond = this.heartRate * 60 + 60;
        if (currentTimeMillis - lastTime > (long)(heartBeatAliveSecond * 1000)) {
            logger.debug("\u5fc3\u8df3\u65f6\u95f4\u8fc7\u671f\uff0c\u4e22\u5f03");
            return MessageResponse.SUCCESS;
        }
        String key = "SCHEDULER_" + appCode;
        String oldHearTime = (String)this.cacheService.getCache(key, String.class);
        if (StringUtils.isBlank((CharSequence)oldHearTime)) {
            logger.debug("\u65e0\u5fc3\u8df3\u8bb0\u5f55");
        } else {
            logger.debug("\u66f4\u65b0\u524d\u65f6\u95f4\uff1a " + this.sdf.format(Long.parseLong(oldHearTime)));
        }
        this.cacheService.setCache(key, (Object)lastTime, heartBeatAliveSecond);
        String newHearTime = (String)this.cacheService.getCache(key, String.class);
        if (StringUtils.isBlank((CharSequence)newHearTime)) {
            logger.error("\u66f4\u65b0\u540e\u65e0\u5fc3\u8df3\u8bb0\u5f55");
        } else {
            logger.debug("\u66f4\u65b0\u540e\u65f6\u95f4\uff1a " + this.sdf.format(Long.parseLong(newHearTime)));
        }
        return MessageResponse.SUCCESS;
    }
}

