/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.scheduler.biz.quartz.processor;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskInstUpdateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.biz.service.IRetryService;
import com.dtyunxi.yundt.cube.center.scheduler.biz.service.ITaskInstService;
import com.dtyunxi.yundt.cube.center.scheduler.biz.service.ITaskInstShardService;
import com.dtyunxi.yundt.cube.center.scheduler.biz.service.ITaskRelationService;
import com.dtyunxi.yundt.cube.center.scheduler.biz.vo.TaskExecutorVo;
import com.dtyunxi.yundt.cube.center.scheduler.common.constants.TaskInstShardStatusEnum;
import com.dtyunxi.yundt.cube.center.scheduler.common.constants.TaskInstShardTypeEnum;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskRespMsg;
import com.dtyunxi.yundt.cube.center.scheduler.dao.eo.TaskInstShardEo;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TaskRespMqProcessor
implements IMessageProcessor<TaskRespMsg> {
    private static final Logger logger = LoggerFactory.getLogger(TaskRespMqProcessor.class);
    private ExecutorService executor = new ThreadPoolExecutor(5, 15, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1000));
    private ITaskInstService taskInstanceService;
    private ITaskInstShardService taskInstShardService;
    private ITaskRelationService taskRelationService;
    private IRetryService retryService;

    public TaskRespMqProcessor(ITaskInstService taskInstanceService, ITaskInstShardService taskInstShardService, ITaskRelationService taskRelationService, IRetryService retryService) {
        this.taskInstanceService = taskInstanceService;
        this.taskInstShardService = taskInstShardService;
        this.taskRelationService = taskRelationService;
        this.retryService = retryService;
    }

    public MessageResponse process(TaskRespMsg taskRespMsg) {
        try {
            logger.info(Thread.currentThread().getName() + " \u63a5\u6536\u5230\u4efb\u52a1\u6267\u884c\u72b6\u6001\u56de\u4f20MQ\u6d88\u606f: " + JSON.toJSONString((Object)taskRespMsg));
            this.executor.execute(new RespTask(taskRespMsg, this.taskInstanceService, this.taskInstShardService, this.taskRelationService, this.retryService));
        }
        catch (RejectedExecutionException e) {
            logger.error("countering RejectedExecutionException, " + e.getMessage());
        }
        catch (Exception e) {
            logger.error("Failed to process the task resp, " + e.getMessage());
        }
        return MessageResponse.SUCCESS;
    }

    class RespTask
    implements Runnable {
        private TaskRespMsg taskRespMsg;
        private ITaskInstService taskInstService;
        private ITaskInstShardService taskInstShardService;
        private ITaskRelationService taskRelationService;
        private IRetryService retryService;

        public RespTask(TaskRespMsg taskRespMsg, ITaskInstService taskInstanceService, ITaskInstShardService taskInstShardService, ITaskRelationService taskRelationService, IRetryService retryService) {
            this.taskRespMsg = taskRespMsg;
            this.taskInstService = taskInstanceService;
            this.taskInstShardService = taskInstShardService;
            this.taskRelationService = taskRelationService;
            this.retryService = retryService;
        }

        @Override
        public void run() {
            TaskInstShardEo eo;
            Long taskInstShardId = this.taskRespMsg.getTaskInstShardId();
            Long parentId = this.taskRespMsg.getParentId();
            String status = this.taskRespMsg.getStatus();
            String failReason = this.taskRespMsg.getFailReason();
            boolean addRetryLog = false;
            if (parentId == null) {
                TaskInstShardEo shardEo = this.taskInstShardService.selectById(taskInstShardId);
                if (shardEo == null) {
                    logger.error("\u670d\u52a1\u7aef\u5206\u7247\u4e0d\u5b58\u5728 | taskInstShardId=" + taskInstShardId);
                    return;
                }
                if (TaskInstShardStatusEnum.FAILED.getCode().equals(shardEo.getStatus()) || TaskInstShardStatusEnum.EXCP.getCode().equals(shardEo.getStatus())) {
                    addRetryLog = true;
                }
                eo = new TaskInstShardEo();
                eo.setId(taskInstShardId);
                eo.setStatus(status);
                eo.setShardNum(this.taskRespMsg.getShardNum());
                if (StringUtils.isNotBlank((CharSequence)failReason)) {
                    eo.setFailReason(failReason);
                } else {
                    eo.setFailReason("");
                }
                this.taskInstShardService.modifyTaskInstShard(eo);
            } else {
                TaskInstShardEo eo2;
                TaskInstShardEo parentShardEo = this.taskInstShardService.selectById(parentId);
                if (parentShardEo == null) {
                    logger.error("\u7236\u5206\u7247\u4e0d\u5b58\u5728 | parentId=" + parentId);
                    return;
                }
                TaskInstShardEo shardEo = this.taskInstShardService.selectById(taskInstShardId);
                if (shardEo == null) {
                    eo2 = new TaskInstShardEo();
                    eo2.setId(taskInstShardId);
                    eo2.setTaskInstId(this.taskRespMsg.getTaskInstId());
                    eo2.setTaskId(this.taskRespMsg.getTaskId());
                    eo2.setAppBizId(parentShardEo.getAppBizId());
                    eo2.setShardType(TaskInstShardTypeEnum.CLIENT.getCode());
                    eo2.setStatus(status);
                    eo2.setFailReason(failReason);
                    Long addTaskInstShard = this.taskInstShardService.addTaskInstShard(eo2);
                    logger.debug("==========>>>> taskInstShardId = " + taskInstShardId + "; addTaskInstShard = " + addTaskInstShard);
                } else {
                    if (TaskInstShardStatusEnum.FAILED.getCode().equals(shardEo.getStatus()) || TaskInstShardStatusEnum.EXCP.getCode().equals(shardEo.getStatus())) {
                        addRetryLog = true;
                    }
                    eo2 = new TaskInstShardEo();
                    eo2.setId(taskInstShardId);
                    eo2.setStatus(status);
                    if (StringUtils.isNotBlank((CharSequence)failReason)) {
                        eo2.setFailReason(failReason);
                    } else {
                        eo2.setFailReason("");
                    }
                    this.taskInstShardService.modifyTaskInstShard(eo2);
                }
            }
            TaskExecutorVo executorVo = new TaskExecutorVo(this.taskRespMsg.getTaskId(), null, this.taskRespMsg.getTaskBatchId(), this.taskRespMsg.getTaskBatchInstId(), this.taskRespMsg.getTaskInstId());
            executorVo.setTaskInstShardId(this.taskRespMsg.getTaskInstShardId());
            if (addRetryLog) {
                executorVo.setRetryType(1);
            }
            if (this.taskRespMsg.getRetryType() > 0) {
                executorVo.setRetryType(this.taskRespMsg.getRetryType());
            }
            if (TaskInstShardStatusEnum.FAILED.getCode().equals(this.taskRespMsg.getStatus())) {
                if (this.retryService.retry(executorVo, TaskInstShardStatusEnum.FAILED.getCode(), "\u6267\u884c\u7aef\u53cd\u9988\u5931\u8d25")) {
                    return;
                }
            } else if (addRetryLog) {
                this.retryService.retry(executorVo, TaskInstShardStatusEnum.SUCCESS.getCode(), null);
            }
            eo = new TaskInstShardEo();
            eo.setTaskInstId(this.taskRespMsg.getTaskInstId());
            List<TaskInstShardEo> taskInstShardEoList = this.taskInstShardService.queryByEo(eo);
            if (this.isAllDone(taskInstShardEoList)) {
                TaskInstUpdateReqDto taskInstanceDto = new TaskInstUpdateReqDto();
                TaskInstShardEo tmp = this.getFailedTaskInstShardEo(taskInstShardEoList);
                if (null == tmp) {
                    taskInstanceDto.setStatus(TaskInstShardStatusEnum.SUCCESS.getCode());
                } else {
                    taskInstanceDto.setStatus(TaskInstShardStatusEnum.FAILED.getCode());
                    taskInstanceDto.setFailReason(tmp.getFailReason());
                }
                try {
                    this.taskInstService.modify(this.taskRespMsg.getTaskInstId(), taskInstanceDto);
                }
                catch (Exception e) {
                    logger.error("Failed to modify the status of sc_task_instance, " + e.getMessage());
                }
                if (this.taskRespMsg.getTaskBatchId() != null && !this.taskRespMsg.getTaskId().equals(this.taskRespMsg.getTaskBatchId())) {
                    this.taskRelationService.executeTaskBatch(this.taskRespMsg.getTaskBatchId(), this.taskRespMsg.getTaskBatchInstId(), this.taskRespMsg.getTaskId(), taskInstanceDto.getStatus(), taskInstanceDto.getFailReason());
                }
            }
        }

        private boolean isAllDone(List<TaskInstShardEo> taskInstShardEoList) {
            for (TaskInstShardEo eo : taskInstShardEoList) {
                if (!TaskInstShardStatusEnum.RUNNING.getCode().equals(eo.getStatus())) continue;
                return false;
            }
            return true;
        }

        private TaskInstShardEo getFailedTaskInstShardEo(List<TaskInstShardEo> taskInstShardEoList) {
            for (TaskInstShardEo eo : taskInstShardEoList) {
                if (!TaskInstShardStatusEnum.FAILED.getCode().equals(eo.getStatus()) && !TaskInstShardStatusEnum.EXCP.getCode().equals(eo.getStatus())) continue;
                return eo;
            }
            return null;
        }
    }
}

