/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.scheduler.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.AppBizCreateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.AppBizQueryReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.AppBizUpdateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.response.AppBizQueryRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.biz.service.IAppBizService;
import com.dtyunxi.yundt.cube.center.scheduler.common.constants.TaskStatusEnum;
import com.dtyunxi.yundt.cube.center.scheduler.dao.das.AppBizDas;
import com.dtyunxi.yundt.cube.center.scheduler.dao.eo.AppBizEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AppBizServiceImpl
implements IAppBizService {
    private static Logger logger = LoggerFactory.getLogger(AppBizServiceImpl.class);
    @Resource
    private AppBizDas appBizDas;

    @Override
    public AppBizQueryRespDto queryById(Long id) {
        AppBizEo eo = (AppBizEo)this.appBizDas.selectByPrimaryKey(id);
        if (eo == null) {
            throw new BusinessRuntimeException("11002", "\u5e94\u7528\u4e1a\u52a1\u4e0d\u5b58\u5728");
        }
        AppBizQueryRespDto dto = new AppBizQueryRespDto();
        DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)dto);
        return dto;
    }

    @Override
    public List<AppBizQueryRespDto> queryByAppCode(String appCode) {
        AppBizEo eo = new AppBizEo();
        eo.setAppCode(appCode);
        List eoList = this.appBizDas.select((BaseEo)eo);
        ArrayList<AppBizQueryRespDto> dtoList = new ArrayList<AppBizQueryRespDto>();
        DtoHelper.eoList2DtoList((Collection)eoList, dtoList, AppBizQueryRespDto.class);
        return dtoList;
    }

    @Override
    public List<AppBizQueryRespDto> queryAll() {
        List eoList = this.appBizDas.selectAll();
        ArrayList<AppBizQueryRespDto> dtoList = new ArrayList<AppBizQueryRespDto>();
        DtoHelper.eoList2DtoList((Collection)eoList, dtoList, AppBizQueryRespDto.class);
        return dtoList;
    }

    @Override
    public PageInfo<AppBizQueryRespDto> queryByPage(AppBizQueryReqDto appBizQueryReqDto, Integer pageNum, Integer pageSize) {
        AppBizEo eo = new AppBizEo();
        DtoHelper.dto2Eo((BaseVo)appBizQueryReqDto, (BaseEo)eo);
        ArrayList<SqlFilter> filters = new ArrayList<SqlFilter>();
        if (StringUtils.isNotBlank((CharSequence)appBizQueryReqDto.getBizName())) {
            filters.add(SqlFilter.like((String)"biz_name", (Object)("%" + appBizQueryReqDto.getBizName() + "%")));
            eo.setBizName(null);
        }
        if (StringUtils.isNotBlank((CharSequence)appBizQueryReqDto.getStartTime())) {
            filters.add(SqlFilter.ge((String)"update_time", (Object)appBizQueryReqDto.getStartTime()));
        }
        if (StringUtils.isNotBlank((CharSequence)appBizQueryReqDto.getEndTime())) {
            filters.add(SqlFilter.lt((String)"update_time", (Object)appBizQueryReqDto.getEndTime()));
        }
        eo.setSqlFilters(filters);
        eo.setOrderByDesc("update_time");
        PageInfo eoPageInfo = this.appBizDas.selectPage((BaseEo)eo, pageNum, pageSize);
        ArrayList dtoList = new ArrayList();
        PageInfo dtoPageInfo = new PageInfo(dtoList);
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, AppBizQueryRespDto.class);
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        return dtoPageInfo;
    }

    @Override
    public Long add(AppBizCreateReqDto appBizCreateReqDto) {
        AppBizEo eo = new AppBizEo();
        eo.setAppCode(appBizCreateReqDto.getAppCode());
        eo.setBizCode(appBizCreateReqDto.getBizCode());
        if (this.appBizDas.count((BaseEo)eo) > 0) {
            throw new BusinessRuntimeException("11001", "\u5e94\u7528\u7f16\u7801\u4e0e\u4e1a\u52a1\u7f16\u7801\u5fc5\u987b\u552f\u4e00");
        }
        DtoHelper.dto2Eo((BaseVo)appBizCreateReqDto, (BaseEo)eo);
        eo.setStatus(TaskStatusEnum.ENABLE.getCode());
        this.appBizDas.insert((BaseEo)eo);
        return eo.getId();
    }

    @Override
    public void modify(Long id, AppBizUpdateReqDto appBizUpdateReqDto) {
        AppBizEo eo = new AppBizEo();
        eo.setId(id);
        if (this.appBizDas.count((BaseEo)eo) < 1) {
            throw new BusinessRuntimeException("11002", "\u5e94\u7528\u4e1a\u52a1ID\u4e0d\u5b58\u5728");
        }
        DtoHelper.dto2Eo((BaseVo)appBizUpdateReqDto, (BaseEo)eo);
        this.appBizDas.updateSelective((BaseEo)eo);
    }

    @Override
    @Transactional
    public void remove(Long id) {
        AppBizEo eo = (AppBizEo)this.appBizDas.selectByPrimaryKey(id);
        if (eo == null) {
            throw new BusinessRuntimeException("11002", "\u5e94\u7528\u4e1a\u52a1ID\u4e0d\u5b58\u5728");
        }
        if (TaskStatusEnum.ENABLE.getCode().equals(eo.getStatus())) {
            throw new BusinessRuntimeException("10002", "\u5df2\u542f\u7528\u7684\u5e94\u7528\u4e1a\u52a1\u4e0d\u80fd\u88ab\u5220\u9664");
        }
        this.appBizDas.delete((BaseEo)eo);
    }

    @Override
    public void enableById(Long id) {
        AppBizEo eo = (AppBizEo)this.appBizDas.selectByPrimaryKey(id);
        if (eo == null) {
            throw new BusinessRuntimeException("11002", "Task ID\u4e0d\u5b58\u5728");
        }
        if (TaskStatusEnum.ENABLE.getCode().equals(eo.getStatus())) {
            throw new BusinessRuntimeException("Task\u5df2\u4e3a\u542f\u7528\u72b6\u6001\uff0c\u65e0\u9700\u518d\u6b21\u542f\u7528");
        }
        eo.setStatus(TaskStatusEnum.ENABLE.getCode());
        this.appBizDas.updateSelective((BaseEo)eo);
    }

    @Override
    public void disableById(Long id) {
        AppBizEo eo = (AppBizEo)this.appBizDas.selectByPrimaryKey(id);
        if (eo == null) {
            throw new BusinessRuntimeException("11002", "Task ID\u4e0d\u5b58\u5728");
        }
        if (TaskStatusEnum.DISABLE.getCode().equals(eo.getStatus())) {
            throw new BusinessRuntimeException("Task\u5df2\u4e3a\u7981\u7528\u72b6\u6001\uff0c\u65e0\u9700\u518d\u6b21\u7981\u7528");
        }
        eo.setStatus(TaskStatusEnum.DISABLE.getCode());
        this.appBizDas.updateSelective((BaseEo)eo);
    }
}

