/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.scheduler.biz.service.impl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.scheduler.biz.quartz.job.CommonSingleJob;
import com.dtyunxi.yundt.cube.center.scheduler.biz.quartz.job.JobInfo;
import com.dtyunxi.yundt.cube.center.scheduler.biz.service.IQuartzService;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerMetaData;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QuartzService
implements IQuartzService {
    private static final Logger logger = LoggerFactory.getLogger(QuartzService.class);
    private static final String CLASS_NAME_KEY = "className";
    @Autowired
    private Scheduler scheduler;

    @Override
    public void scheduleJob(String cron, String jobName, String jobGroup) {
        try {
            TriggerKey triggerKey = TriggerKey.triggerKey((String)jobName, (String)jobGroup);
            CronTrigger cronTrigger = (CronTrigger)this.scheduler.getTrigger(triggerKey);
            if (null != cronTrigger) {
                throw new BusinessRuntimeException("11001", "The job already exists");
            }
            JobDetail jobDetail = JobBuilder.newJob(CommonSingleJob.class).withIdentity(jobName, jobGroup).build();
            jobDetail.getJobDataMap().put(CLASS_NAME_KEY, CommonSingleJob.class.getName());
            CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)cron);
            cronTrigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(jobName, jobGroup).withSchedule((ScheduleBuilder)scheduleBuilder).build();
            logger.info("Creating the job, jobName = {}, jobGroup = {}", (Object)jobName, (Object)jobGroup);
            this.scheduler.scheduleJob(jobDetail, (Trigger)cronTrigger);
        }
        catch (BusinessRuntimeException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SchedulerException e) {
            logger.error("Failed to create the job", (Throwable)e);
            throw new BizException("500", "\u4efb\u52a1\u5df2\u8fc7\u671f\uff0c \u64cd\u4f5c\u65e0\u6548");
        }
        catch (Exception e) {
            logger.error("Failed to create the job", (Throwable)e);
            throw new BusinessRuntimeException("10001", (Throwable)e);
        }
    }

    @Override
    public void scheduleJob(String cron, String jobName, String jobGroup, Class jobClass) {
        try {
            TriggerKey triggerKey = TriggerKey.triggerKey((String)jobName, (String)jobGroup);
            CronTrigger cronTrigger = (CronTrigger)this.scheduler.getTrigger(triggerKey);
            if (null != cronTrigger) {
                throw new BusinessRuntimeException("11001", "The job already exists");
            }
            JobDetail jobDetail = JobBuilder.newJob((Class)jobClass).withIdentity(jobName, jobGroup).build();
            jobDetail.getJobDataMap().put(CLASS_NAME_KEY, CommonSingleJob.class.getName());
            CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)cron).withMisfireHandlingInstructionDoNothing();
            cronTrigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(jobName, jobGroup).withSchedule((ScheduleBuilder)scheduleBuilder).build();
            logger.info("Creating the job, jobName = {}, jobGroup = {}", (Object)jobName, (Object)jobGroup);
            this.scheduler.scheduleJob(jobDetail, (Trigger)cronTrigger);
        }
        catch (BusinessRuntimeException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SchedulerException e) {
            logger.error("Failed to create the job", (Throwable)e);
            throw new BizException("500", "\u4efb\u52a1\u5df2\u8fc7\u671f\uff0c \u64cd\u4f5c\u65e0\u6548");
        }
        catch (Exception e) {
            logger.error("Failed to create the job", (Throwable)e);
            throw new BusinessRuntimeException("10001", (Throwable)e);
        }
    }

    @Override
    public void pauseJob(String jobName, String jobGroup) {
        try {
            JobKey jobKey = new JobKey(jobName, jobGroup);
            JobDetail jobDetail = this.scheduler.getJobDetail(jobKey);
            if (null == jobDetail) {
                return;
            }
            logger.info("Pausing the job, jobName = {}, jobGroup = {}", (Object)jobName, (Object)jobGroup);
            this.scheduler.pauseJob(jobKey);
        }
        catch (Exception e) {
            logger.error("Failed to pause the job", (Throwable)e);
            throw new BusinessRuntimeException("10001", (Throwable)e);
        }
    }

    @Override
    public void resumeJob(String jobName, String jobGroup) {
        try {
            JobKey jobKey = new JobKey(jobName, jobGroup);
            JobDetail jobDetail = this.scheduler.getJobDetail(jobKey);
            if (null == jobDetail) {
                return;
            }
            logger.info("Resuming the paused job, jobName = {}, jobGroup = {}", (Object)jobName, (Object)jobGroup);
            this.scheduler.resumeJob(jobKey);
        }
        catch (Exception e) {
            logger.error("Failed to resume the paused job", (Throwable)e);
            throw new BusinessRuntimeException("10001", (Throwable)e);
        }
    }

    @Override
    public void deleteJob(String jobName, String jobGroup) {
        try {
            JobKey jobKey = new JobKey(jobName, jobGroup);
            JobDetail jobDetail = this.scheduler.getJobDetail(jobKey);
            if (null == jobDetail) {
                return;
            }
            logger.info("Deleting the job, jobName = {}, jobGroup = {}", (Object)jobName, (Object)jobGroup);
            this.scheduler.deleteJob(jobKey);
        }
        catch (Exception e) {
            logger.error("Failed to delete the job", (Throwable)e);
            throw new BusinessRuntimeException("10001", (Throwable)e);
        }
    }

    @Override
    public void execJobNow(String jobName, String jobGroup) {
        try {
            JobKey jobKey = JobKey.jobKey((String)jobName, (String)jobGroup);
            JobDetail jobDetail = this.scheduler.getJobDetail(jobKey);
            if (null == jobDetail) {
                throw new BusinessRuntimeException("11002", "The job does not exist");
            }
            logger.info("Immediately execute the job, jobName = {}, jobGroup = {}", (Object)jobName, (Object)jobGroup);
            this.scheduler.triggerJob(jobKey);
        }
        catch (BusinessRuntimeException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("Failed to execute the job immediately", (Throwable)e);
            throw new BusinessRuntimeException("10001", (Throwable)e);
        }
    }

    @Override
    public void rescheduleJob(String cron, String jobName, String jobGroup) {
        try {
            TriggerKey triggerKey = TriggerKey.triggerKey((String)jobName, (String)jobGroup);
            CronTrigger trigger = (CronTrigger)this.scheduler.getTrigger(triggerKey);
            if (null == trigger) {
                this.scheduleJob(cron, jobName, jobGroup);
                logger.info("The job does not exist, creating job, jobName = {}, jobGroup = {}, cron = {}", new Object[]{jobName, jobGroup, cron});
                return;
            }
            CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)cron).withMisfireHandlingInstructionDoNothing();
            trigger = (CronTrigger)trigger.getTriggerBuilder().withIdentity(triggerKey).withSchedule((ScheduleBuilder)scheduleBuilder).build();
            logger.info("Rescheduling the job, jobName = {}, jobGroup = {}, cron = {}", new Object[]{jobName, jobGroup, cron});
            this.scheduler.rescheduleJob(triggerKey, (Trigger)trigger);
        }
        catch (BusinessRuntimeException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("Failed to reschedule the job", (Throwable)e);
            throw new BusinessRuntimeException("10001", (Throwable)e);
        }
    }

    @Override
    public SchedulerMetaData getMetaData() {
        SchedulerMetaData metaData = null;
        try {
            metaData = this.scheduler.getMetaData();
        }
        catch (Exception e) {
            logger.error("Failed to get metaData", (Throwable)e);
            return null;
        }
        return metaData;
    }

    @Override
    public List<JobInfo> getAllJobList() {
        ArrayList<JobInfo> jobList = new ArrayList<JobInfo>();
        try {
            GroupMatcher matcher = GroupMatcher.anyJobGroup();
            Set jobKeySet = this.scheduler.getJobKeys(matcher);
            for (JobKey jobKey : jobKeySet) {
                List triggers = this.scheduler.getTriggersOfJob(jobKey);
                for (Trigger trigger : triggers) {
                    JobInfo jobInfo = new JobInfo();
                    this.wrapScheduleJob(jobInfo, this.scheduler, jobKey, trigger);
                    jobList.add(jobInfo);
                }
            }
        }
        catch (Exception e) {
            logger.error("Failed to get the job list", (Throwable)e);
            return null;
        }
        return jobList;
    }

    @Override
    public List<JobInfo> getRunningJobList() {
        ArrayList<JobInfo> jobList = null;
        try {
            List executingJobList = this.scheduler.getCurrentlyExecutingJobs();
            jobList = new ArrayList<JobInfo>(executingJobList.size());
            for (JobExecutionContext executingJob : executingJobList) {
                JobInfo jobInfo = new JobInfo();
                JobDetail jobDetail = executingJob.getJobDetail();
                JobKey jobKey = jobDetail.getKey();
                Trigger trigger = executingJob.getTrigger();
                this.wrapScheduleJob(jobInfo, this.scheduler, jobKey, trigger);
                jobList.add(jobInfo);
            }
        }
        catch (Exception e) {
            logger.error("Failed to get the running job list", (Throwable)e);
            return null;
        }
        return jobList;
    }

    @Override
    public void startAllJob() {
        try {
            logger.info("Starting the scheduler");
            this.scheduler.start();
        }
        catch (Exception e) {
            logger.error("Failed to start the scheduler", (Throwable)e);
            throw new BusinessRuntimeException("10001", (Throwable)e);
        }
    }

    @Override
    public void shutdown(boolean waitForJobsToComplete) {
        try {
            logger.info("Shuting down the scheduler");
            this.scheduler.shutdown(waitForJobsToComplete);
        }
        catch (Exception e) {
            logger.error("Failed to shut down the scheduler", (Throwable)e);
            throw new BusinessRuntimeException("10001", (Throwable)e);
        }
    }

    private void wrapScheduleJob(JobInfo jobInfo, Scheduler scheduler, JobKey jobKey, Trigger trigger) {
        try {
            jobInfo.setJobName(jobKey.getName());
            jobInfo.setJobGroup(jobKey.getGroup());
            JobDetail jobDetail = scheduler.getJobDetail(jobKey);
            String className = (String)jobDetail.getJobDataMap().get((Object)CLASS_NAME_KEY);
            jobInfo.setClassName(className);
            Trigger.TriggerState triggerState = scheduler.getTriggerState(trigger.getKey());
            jobInfo.setJobStatus(triggerState.name());
            if (trigger instanceof CronTrigger) {
                CronTrigger cronTrigger = (CronTrigger)trigger;
                String cronExpression = cronTrigger.getCronExpression();
                jobInfo.setCronExpression(cronExpression);
            }
        }
        catch (Exception e) {
            logger.error("Failed to wrapScheduleJob, " + e.getMessage());
        }
    }
}

