/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.scheduler.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.RetryLogQueryReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.response.RetryLogRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.biz.service.IRetryLogService;
import com.dtyunxi.yundt.cube.center.scheduler.biz.vo.TaskExecutorVo;
import com.dtyunxi.yundt.cube.center.scheduler.common.constants.TaskInstShardStatusEnum;
import com.dtyunxi.yundt.cube.center.scheduler.dao.das.RetryLogDas;
import com.dtyunxi.yundt.cube.center.scheduler.dao.eo.RetryLogEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class RetryLogServiceImpl
implements IRetryLogService {
    @Resource
    private RetryLogDas retryLogDas;

    @Override
    public void addRetryLog(TaskExecutorVo executorVo, String status, String failReason) {
        RetryLogEo retryLogEo = new RetryLogEo();
        DtoHelper.dto2Eo((BaseVo)executorVo, (BaseEo)retryLogEo);
        if (!TaskInstShardStatusEnum.SUCCESS.getCode().equals(status)) {
            retryLogEo.setFailReason(failReason);
            retryLogEo.setStatus(TaskInstShardStatusEnum.EXCP.getCode());
        } else {
            retryLogEo.setStatus(TaskInstShardStatusEnum.SUCCESS.getCode());
        }
        this.retryLogDas.insert((BaseEo)retryLogEo);
    }

    @Override
    public PageInfo<RetryLogRespDto> queryByPage(RetryLogQueryReqDto retryLogQueryReqDto, Integer pageNum, Integer pageSize) {
        RetryLogEo retryLogEo = new RetryLogEo();
        DtoHelper.dto2Eo((BaseVo)retryLogQueryReqDto, (BaseEo)retryLogEo);
        if (retryLogEo.getTaskInstId() != null && retryLogEo.getTaskInstShardId() == null) {
            ArrayList<SqlFilter> filters = new ArrayList<SqlFilter>();
            filters.add(SqlFilter.isNull((String)"task_inst_shard_id"));
            retryLogEo.setSqlFilters(filters);
        }
        retryLogEo.setOrderByDesc("create_time");
        PageInfo eoPageInfo = this.retryLogDas.selectPage((BaseEo)retryLogEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, RetryLogRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

