/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.scheduler.biz.service.impl;

import com.dtyunxi.cube.enhance.CubeResource;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.RetryLogQueryReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.response.AppBizQueryRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.response.RetryLogRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.response.TaskQueryRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.biz.annotation.Retryable;
import com.dtyunxi.yundt.cube.center.scheduler.biz.quartz.job.AutoRetryJob;
import com.dtyunxi.yundt.cube.center.scheduler.biz.service.IQuartzService;
import com.dtyunxi.yundt.cube.center.scheduler.biz.service.IRetryLogService;
import com.dtyunxi.yundt.cube.center.scheduler.biz.service.IRetryService;
import com.dtyunxi.yundt.cube.center.scheduler.biz.service.ITaskInstService;
import com.dtyunxi.yundt.cube.center.scheduler.biz.service.ITaskInstShardService;
import com.dtyunxi.yundt.cube.center.scheduler.biz.service.ITaskService;
import com.dtyunxi.yundt.cube.center.scheduler.biz.task.RetryTaskExecutor;
import com.dtyunxi.yundt.cube.center.scheduler.biz.vo.RetryVo;
import com.dtyunxi.yundt.cube.center.scheduler.biz.vo.TaskExecutorVo;
import com.dtyunxi.yundt.cube.center.scheduler.common.constants.TaskInstShardStatusEnum;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.dtyunxi.yundt.cube.center.scheduler.conf.param.IRetryNumParam;
import com.dtyunxi.yundt.cube.center.scheduler.conf.param.IRetrySleepTimeIsMultipleParam;
import com.dtyunxi.yundt.cube.center.scheduler.conf.param.IRetrySleepTimeParam;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RetryServiceImpl
implements IRetryService {
    private static final Logger logger = LoggerFactory.getLogger(RetryServiceImpl.class);
    @Autowired
    ITaskService taskService;
    @Autowired
    ITaskInstService taskInstService;
    @Autowired
    ITaskInstShardService taskInstShardService;
    @Resource
    IQuartzService quartzService;
    @Resource
    RetryTaskExecutor retryTaskExecutor;
    @Autowired
    ICacheService cacheService;
    @Autowired
    ICommonsMqService commonsMqService;
    @Resource
    IRetryLogService retryLogService;
    @CubeResource
    IRetryNumParam retryNumParam;
    @CubeResource
    IRetrySleepTimeParam retrySleepTimeParam;
    @CubeResource
    IRetrySleepTimeIsMultipleParam retrySleepTimeIsMultipleParam;

    @Override
    public boolean retry(TaskExecutorVo executorVo, String status, String failReason) {
        if (1 == executorVo.getRetryType() || 2 == executorVo.getRetryType()) {
            this.retryLogService.addRetryLog(executorVo, status, failReason);
        }
        if (2 == executorVo.getRetryType()) {
            return false;
        }
        if (TaskInstShardStatusEnum.SUCCESS.getCode().equals(status)) {
            return false;
        }
        return this.doRetry(executorVo.getTaskId(), executorVo.getTaskInstId(), executorVo.getTaskInstShardId());
    }

    public boolean doRetry(Long taskId, Long taskInstId, Long taskInstShardId) {
        int retryNum;
        TaskQueryRespDto taskDto = this.taskService.queryById(taskId);
        boolean isRetry = taskDto.getIsRetry() == null ? false : taskDto.getIsRetry();
        int n = retryNum = taskDto.getRetryNum() == null ? 0 : taskDto.getRetryNum();
        if (isRetry && retryNum <= 0 && this.retryNumParam.getValue() != null) {
            retryNum = (Integer)this.retryNumParam.getValue();
            logger.info("\u4efb\u52a1id[{}]\u4f7f\u7528\u4e1a\u52a1\u53c2\u6570[\u4efb\u52a1\u91cd\u8bd5\u6b21\u6570\u8bbe\u7f6e]\u7684\u503c[{}]\u8fdb\u884c\u91cd\u8bd5", (Object)taskId, (Object)retryNum);
        }
        int triedNum = this.getTriedNum(taskInstId, taskInstShardId);
        if (isRetry && triedNum < retryNum) {
            int sleepTime;
            if (taskInstShardId == null) {
                logger.info("\u4efb\u52a1\u5b9e\u4f8bid[{}]\u6b63\u5728\u8fdb\u884c\u7b2c[{}]\u6b21\u91cd\u8bd5", (Object)taskInstId, (Object)(triedNum + 1));
            } else {
                logger.info("\u4efb\u52a1\u5b9e\u4f8b\u5206\u7247id[{}]\u6b63\u5728\u8fdb\u884c\u7b2c[{}]\u6b21\u91cd\u8bd5", (Object)taskInstShardId, (Object)(triedNum + 1));
            }
            int n2 = sleepTime = taskDto.getSleepTime() == null ? 0 : taskDto.getSleepTime();
            if (sleepTime <= 0 && this.retrySleepTimeParam.getValue() != null) {
                sleepTime = (Integer)this.retrySleepTimeParam.getValue();
                logger.info("\u4efb\u52a1id[{}]\u4f7f\u7528\u4e1a\u52a1\u53c2\u6570[\u4efb\u52a1\u91cd\u8bd5\u65f6\u957f\u8bbe\u7f6e]\u7684\u503c[{}]\u8fdb\u884c\u91cd\u8bd5", (Object)taskId, (Object)sleepTime);
            }
            if (sleepTime > 0) {
                boolean isMultiple = false;
                if (taskDto.getIsMultiple() == null) {
                    if (this.retrySleepTimeIsMultipleParam.getValue() != null) {
                        isMultiple = (Boolean)this.retrySleepTimeIsMultipleParam.getValue();
                        logger.info("\u4efb\u52a1id[{}]\u4f7f\u7528\u4e1a\u52a1\u53c2\u6570[\u4e1a\u52a1\u53c2\u6570\u91cd\u8bd5\u65f6\u95f4\u95f4\u9694\u662f\u5426\u500d\u6570\u589e\u957f]\u7684\u503c[{}]\u8fdb\u884c\u91cd\u8bd5", (Object)taskId, (Object)isMultiple);
                    }
                } else {
                    isMultiple = taskDto.getIsMultiple();
                }
                if (isMultiple) {
                    sleepTime *= triedNum + 1;
                }
                String cron = DateUtil.getDateFormat((Date)DateUtil.addSeconds((Date)new Date(), (int)sleepTime), (String)"ss mm HH dd MM ? yyyy");
                if (taskInstShardId == null) {
                    this.quartzService.scheduleJob(cron, IdGenrator.getDistributedId() + "," + taskInstId, "" + taskInstId, AutoRetryJob.class);
                } else {
                    this.quartzService.scheduleJob(cron, IdGenrator.getDistributedId() + "," + taskInstId, "" + taskInstShardId, AutoRetryJob.class);
                }
            } else {
                RetryVo retryVo = new RetryVo(taskInstId, taskInstShardId, 1);
                this.retryTaskExecutor.execute(retryVo);
            }
        } else {
            return false;
        }
        return true;
    }

    private int getTriedNum(Long taskInstId, Long taskInstShardId) {
        int triedNum = 0;
        RetryLogQueryReqDto retryLogQueryReqDto = new RetryLogQueryReqDto();
        retryLogQueryReqDto.setTaskInstId(taskInstId);
        retryLogQueryReqDto.setTaskInstShardId(taskInstShardId);
        retryLogQueryReqDto.setRetryType(Integer.valueOf(1));
        PageInfo<RetryLogRespDto> pageInfo = this.retryLogService.queryByPage(retryLogQueryReqDto, 1, 1000);
        if (pageInfo != null && pageInfo.getList() != null) {
            triedNum = pageInfo.getList().size();
        }
        return triedNum;
    }

    @Override
    @Retryable
    public Boolean isExistActiveNode(AppBizQueryRespDto appBizQueryRespDto, TaskExecutorVo executorVo) {
        String key = "SCHEDULER_" + appBizQueryRespDto.getAppCode();
        String timestamp = (String)this.cacheService.getCache(key, String.class);
        return StringUtils.isNotBlank((CharSequence)timestamp);
    }

    @Override
    @Retryable
    public MessageResponse getMessageResponse(AppBizQueryRespDto appBizQueryRespDto, TaskMsg msgContent, TaskExecutorVo executorVo) {
        MessageResponse mqResp = null;
        try {
            mqResp = this.commonsMqService.sendSingleMessage("SCHEDULER-" + appBizQueryRespDto.getAppCode(), (Object)msgContent);
        }
        catch (Exception e) {
            logger.error("\u63a8\u9001\u4efb\u52a1\u6d88\u606f\u5f02\u5e38", (Throwable)e);
        }
        return mqResp;
    }
}

