/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.scheduler.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskBatchCreateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskBatchQueryReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskBatchUpdateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.response.TaskBatchQueryRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.response.TaskRelationRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.response.TaskRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.biz.service.IQuartzService;
import com.dtyunxi.yundt.cube.center.scheduler.biz.service.ITaskBatchService;
import com.dtyunxi.yundt.cube.center.scheduler.biz.service.ITaskRelationService;
import com.dtyunxi.yundt.cube.center.scheduler.biz.task.TaskExecutor;
import com.dtyunxi.yundt.cube.center.scheduler.common.constants.TaskStatusEnum;
import com.dtyunxi.yundt.cube.center.scheduler.dao.das.TaskBatchDas;
import com.dtyunxi.yundt.cube.center.scheduler.dao.das.TaskDas;
import com.dtyunxi.yundt.cube.center.scheduler.dao.eo.TaskBatchEo;
import com.dtyunxi.yundt.cube.center.scheduler.dao.eo.TaskEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TaskBatchServiceImpl
implements ITaskBatchService {
    @Resource
    private TaskBatchDas taskBatchDas;
    @Resource
    private ITaskRelationService taskRelationService;
    @Resource
    private TaskDas taskDas;
    @Resource
    private ILockService lockService;
    @Resource
    private IQuartzService quartzService;
    @Resource(name="cubeSchedulerTaskExecutor")
    private TaskExecutor taskExecutor;

    @Override
    public Long addTaskBatch(TaskBatchCreateReqDto addReqDto) {
        if (StringUtils.isEmpty((CharSequence)addReqDto.getTaskBatchName())) {
            throw new BusinessRuntimeException("10002", "\u6279\u5904\u7406\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String taskBatchCode = addReqDto.getTaskBatchCode();
        if (StringUtils.isEmpty((CharSequence)taskBatchCode)) {
            throw new BusinessRuntimeException("10002", "\u6279\u5904\u7406\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        TaskBatchEo queryEo = this.taskBatchDas.selectByCode(taskBatchCode);
        if (queryEo != null) {
            throw new BusinessRuntimeException("11001", "\u6279\u5904\u7406\u7f16\u7801\u5df2\u5b58\u5728");
        }
        TaskBatchEo taskBatchEo = new TaskBatchEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)taskBatchEo);
        taskBatchEo.setStatus(TaskStatusEnum.NEW.getCode());
        this.taskBatchDas.insert((BaseEo)taskBatchEo);
        return taskBatchEo.getId();
    }

    @Override
    public void modifyTaskBatch(Long id, TaskBatchUpdateReqDto modifyReqDto) {
        TaskBatchEo eo = (TaskBatchEo)this.taskBatchDas.selectByPrimaryKey(id);
        if (eo == null) {
            throw new BusinessRuntimeException("11002", "\u6279\u5904\u7406\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)eo);
        this.taskBatchDas.updateSelective((BaseEo)eo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeTaskBatch(String ids) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.taskBatchDas.logicDeleteById(Long.valueOf(id));
            this.taskRelationService.deleteTaskRelation(Long.valueOf(id));
        }
    }

    @Override
    public TaskBatchQueryRespDto queryById(Long id) {
        TaskBatchEo taskBatchEo = (TaskBatchEo)this.taskBatchDas.selectByPrimaryKey(id);
        TaskBatchQueryRespDto taskBatchRespDto = new TaskBatchQueryRespDto();
        DtoHelper.eo2Dto((BaseEo)taskBatchEo, (BaseVo)taskBatchRespDto);
        return taskBatchRespDto;
    }

    @Override
    public PageInfo<TaskBatchQueryRespDto> queryByPage(TaskBatchQueryReqDto queryReqDto, Integer pageNum, Integer pageSize) {
        TaskBatchEo taskBatchEo = new TaskBatchEo();
        DtoHelper.dto2Eo((BaseVo)queryReqDto, (BaseEo)taskBatchEo);
        ArrayList<SqlFilter> filters = new ArrayList<SqlFilter>();
        if (StringUtils.isNotBlank((CharSequence)taskBatchEo.getTaskBatchName())) {
            filters.add(SqlFilter.like((String)"task_batch_name", (Object)("%" + taskBatchEo.getTaskBatchName() + "%")));
            taskBatchEo.setTaskBatchName(null);
        }
        if (StringUtils.isNotBlank((CharSequence)queryReqDto.getStartTime())) {
            filters.add(SqlFilter.ge((String)"create_time", (Object)queryReqDto.getStartTime()));
        }
        if (StringUtils.isNotBlank((CharSequence)queryReqDto.getEndTime())) {
            filters.add(SqlFilter.lt((String)"create_time", (Object)queryReqDto.getEndTime()));
        }
        taskBatchEo.setSqlFilters(filters);
        taskBatchEo.setOrderByDesc("create_time");
        PageInfo eoPageInfo = this.taskBatchDas.selectPage((BaseEo)taskBatchEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, TaskBatchQueryRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public void enableById(Long id) {
        Mutex mutex = null;
        try {
            mutex = this.lockService.lock("task_batch", "" + id, 10, 3, TimeUnit.SECONDS);
            TaskBatchEo eo = this.getTaskBatchEo(id, TaskStatusEnum.ENABLE.getCode());
            TaskEo taskEo = this.getTaskEo(id, TaskStatusEnum.ENABLE.getCode());
            this.quartzService.scheduleJob(taskEo.getScheduleExpression(), "" + taskEo.getId(), "" + eo.getId());
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                this.lockService.unlock(mutex);
                throw throwable;
            }
        }
        this.lockService.unlock(mutex);
    }

    private TaskEo getTaskEo(Long id, String status) {
        TaskRelationRespDto taskRelationRespDto = this.taskRelationService.querySufTaskList(id, null);
        List taskRespDtoList = taskRelationRespDto.getTaskList();
        TaskRespDto taskRespDto = (TaskRespDto)taskRespDtoList.get(0);
        TaskEo taskEo = (TaskEo)this.taskDas.selectByPrimaryKey(taskRespDto.getTaskId());
        if (taskEo == null) {
            throw new BusinessRuntimeException("11002", "\u6279\u5904\u7406\u5173\u8054\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        taskEo.setStatus(status);
        this.taskDas.updateSelective((BaseEo)taskEo);
        return taskEo;
    }

    private TaskBatchEo getTaskBatchEo(Long id, String status) {
        TaskBatchEo eo = (TaskBatchEo)this.taskBatchDas.selectByPrimaryKey(id);
        if (eo == null) {
            throw new BusinessRuntimeException("11002", "\u6279\u5904\u7406\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        if (status.equals(eo.getStatus())) {
            throw new BusinessRuntimeException("\u4efb\u52a1\u72b6\u6001\u4e0d\u6b63\u786e");
        }
        eo.setStatus(status);
        this.taskBatchDas.updateSelective((BaseEo)eo);
        return eo;
    }

    @Override
    public void disableById(Long id) {
        Mutex mutex = null;
        try {
            mutex = this.lockService.lock("task_batch", "" + id, 10, 3, TimeUnit.SECONDS);
            TaskBatchEo eo = this.getTaskBatchEo(id, TaskStatusEnum.DISABLE.getCode());
            TaskEo taskEo = this.getTaskEo(id, TaskStatusEnum.DISABLE.getCode());
            this.quartzService.deleteJob(taskEo.getId().toString(), eo.getId().toString());
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                this.lockService.unlock(mutex);
                throw throwable;
            }
        }
        this.lockService.unlock(mutex);
    }

    @Override
    public RestResponse<Long> addTaskBatchInst(Long id) {
        TaskBatchEo eo = (TaskBatchEo)this.taskBatchDas.selectByPrimaryKey(id);
        if (eo == null) {
            throw new BusinessRuntimeException("11002", "\u6279\u5904\u7406\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        TaskEo taskEo = this.getTaskEo(id, TaskStatusEnum.ENABLE.getCode());
        try {
            return this.taskExecutor.execute(taskEo.getId(), null, id, null);
        }
        catch (Exception e) {
            throw new BusinessRuntimeException("10001", "\u624b\u52a8\u89e6\u53d1\u6279\u5904\u7406\u4efb\u52a1\u5931\u8d25");
        }
    }
}

