/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.scheduler.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskBatchInstQueryReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskInstQueryReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskInstUpdateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.response.AppBizQueryRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.response.TaskBatchInstQueryRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.response.TaskInstQueryRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.response.TaskQueryRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.biz.service.IAppBizService;
import com.dtyunxi.yundt.cube.center.scheduler.biz.service.IRetryService;
import com.dtyunxi.yundt.cube.center.scheduler.biz.service.ITaskInstService;
import com.dtyunxi.yundt.cube.center.scheduler.biz.service.ITaskInstShardService;
import com.dtyunxi.yundt.cube.center.scheduler.biz.service.ITaskService;
import com.dtyunxi.yundt.cube.center.scheduler.biz.utils.MqUtils;
import com.dtyunxi.yundt.cube.center.scheduler.biz.vo.TaskExecutorVo;
import com.dtyunxi.yundt.cube.center.scheduler.biz.vo.TaskInstVo;
import com.dtyunxi.yundt.cube.center.scheduler.common.constants.TaskInstShardStatusEnum;
import com.dtyunxi.yundt.cube.center.scheduler.common.constants.TaskInstShardTypeEnum;
import com.dtyunxi.yundt.cube.center.scheduler.common.constants.TaskMsgParallelEnum;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.dtyunxi.yundt.cube.center.scheduler.dao.das.TaskBatchInstDas;
import com.dtyunxi.yundt.cube.center.scheduler.dao.das.TaskInstDas;
import com.dtyunxi.yundt.cube.center.scheduler.dao.eo.TaskInstEo;
import com.dtyunxi.yundt.cube.center.scheduler.dao.eo.TaskInstShardEo;
import com.github.pagehelper.PageInfo;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskInstServiceImpl
implements ITaskInstService {
    private static Logger logger = LoggerFactory.getLogger(TaskInstServiceImpl.class);
    @Resource
    private TaskInstDas taskInstDas;
    @Resource
    private TaskBatchInstDas taskBatchInstDas;
    @Resource
    private ITaskService taskService;
    @Autowired
    IAppBizService appBizService;
    @Autowired
    ICacheService cacheService;
    @Autowired
    ITaskInstShardService taskInstShardService;
    @Autowired
    ICommonsMqService commonsMqService;
    @Autowired
    MqUtils mqUtils;
    @Autowired
    IRetryService retryService;

    @Override
    public TaskInstQueryRespDto queryById(Long id) {
        TaskInstEo eo = (TaskInstEo)this.taskInstDas.selectByPrimaryKey(id);
        if (eo == null) {
            throw new BusinessRuntimeException("11002", "\u4efb\u52a1\u5b9e\u4f8b\u4e0d\u5b58\u5728");
        }
        TaskInstQueryRespDto dto = new TaskInstQueryRespDto();
        DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)dto);
        return dto;
    }

    @Override
    public PageInfo<TaskInstQueryRespDto> queryByPage(Long taskId, TaskInstQueryReqDto taskInstQueryReqDto, Integer pageNum, Integer pageSize) {
        TaskInstEo eo = new TaskInstEo();
        DtoHelper.dto2Eo((BaseVo)taskInstQueryReqDto, (BaseEo)eo);
        eo.setTaskId(taskId);
        PageInfo eoPageInfo = this.taskInstDas.selectPage((BaseEo)eo, pageNum, pageSize);
        ArrayList dtoList = new ArrayList();
        PageInfo dtoPageInfo = new PageInfo(dtoList);
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, TaskInstQueryRespDto.class);
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        if (CollectionUtils.isNotEmpty(dtoList)) {
            for (TaskInstQueryRespDto dto : dtoList) {
                if (TaskInstShardStatusEnum.RUNNING.getCode().equals(dto.getStatus())) {
                    dto.setRunningTime(DateUtil.getTimeDiffWithMilliseconds((Date)dto.getCreateTime(), (Date)new Date()));
                    continue;
                }
                dto.setRunningTime(DateUtil.getTimeDiffWithMilliseconds((Date)dto.getCreateTime(), (Date)dto.getUpdateTime()));
            }
        }
        return dtoPageInfo;
    }

    @Override
    public Long add(Long taskId, TaskInstVo taskInstVo) {
        TaskInstEo eo = new TaskInstEo();
        DtoHelper.dto2Eo((BaseVo)taskInstVo, (BaseEo)eo);
        eo.setTaskId(taskId);
        this.taskInstDas.insert((BaseEo)eo);
        return eo.getId();
    }

    @Override
    public void modify(Long id, TaskInstUpdateReqDto taskInstUpdateReqDto) {
        TaskInstEo eo = new TaskInstEo();
        eo.setId(id);
        if (this.taskInstDas.count((BaseEo)eo) < 1) {
            throw new BusinessRuntimeException("11002", "\u4efb\u52a1\u5b9e\u4f8bID\u4e0d\u5b58\u5728");
        }
        DtoHelper.dto2Eo((BaseVo)taskInstUpdateReqDto, (BaseEo)eo);
        this.taskInstDas.updateSelective((BaseEo)eo);
    }

    @Override
    public PageInfo<TaskBatchInstQueryRespDto> queryByTaskBatchId(Long taskBatchId, TaskBatchInstQueryReqDto queryReqDto, Integer pageNum, Integer pageSize) {
        ArrayList dtoList = new ArrayList();
        PageInfo dtoPageInfo = new PageInfo(dtoList);
        List taskBatchInstEoList = this.taskBatchInstDas.selectByTaskBatchId(taskBatchId);
        if (CollectionUtils.isNotEmpty((Collection)taskBatchInstEoList)) {
            TaskInstEo eo = new TaskInstEo();
            DtoHelper.dto2Eo((BaseVo)queryReqDto, (BaseEo)eo);
            List batchInstIdList = taskBatchInstEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
            ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
            sqlFilterList.add(SqlFilter.in((String)"task_batch_inst_id", (Object)StringUtils.join(batchInstIdList, (String)",")));
            eo.setSqlFilters(sqlFilterList);
            PageInfo eoPageInfo = this.taskInstDas.selectPage((BaseEo)eo, pageNum, pageSize);
            DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, TaskBatchInstQueryRespDto.class);
            CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        }
        for (TaskBatchInstQueryRespDto dto : dtoPageInfo.getList()) {
            dto.setTaskRespDto(this.taskService.queryById(dto.getTaskId()));
            if (TaskInstShardStatusEnum.RUNNING.getCode().equals(dto.getStatus())) {
                DateUtil.getTimeDiff((Date)dto.getCreateTime(), (Date)new Date());
                continue;
            }
            dto.setRunningTime(DateUtil.getTimeDiff((Date)dto.getCreateTime(), (Date)dto.getUpdateTime()));
        }
        return dtoPageInfo;
    }

    @Override
    public void taskInstExecute(TaskExecutorVo executorVo) {
        Long taskInsId = executorVo.getTaskInstId();
        TaskQueryRespDto taskDto = this.taskService.queryById(executorVo.getTaskId());
        AppBizQueryRespDto appBizQueryRespDto = this.appBizService.queryById(taskDto.getAppBizId());
        String appCode = appBizQueryRespDto.getAppCode();
        Boolean isExistActiveNode = this.retryService.isExistActiveNode(appBizQueryRespDto, executorVo);
        if (!isExistActiveNode.booleanValue()) {
            String failReason = "\u8be5\u5e94\u7528\u65e0\u6d3b\u8dc3\u8282\u70b9\uff0c\u4efb\u52a1\u505c\u6b62 | appCode=" + appCode;
            this.modifyTaskInstanceFailed(taskInsId, failReason);
            throw new BusinessRuntimeException("10001", failReason);
        }
        List<TaskInstShardEo> taskInstShardEoList = this.splitTask(taskInsId, taskDto);
        if (taskInstShardEoList == null || taskInstShardEoList.isEmpty()) {
            throw new BusinessRuntimeException("10001", "\u65e0\u4efb\u52a1\u5206\u7247\uff0c\u4efb\u52a1\u505c\u6b62");
        }
        this.taskInstShardService.addTaskInstShardList(taskInstShardEoList);
        boolean isSendMQSuccess = true;
        for (TaskInstShardEo taskInstShardEo : taskInstShardEoList) {
            isSendMQSuccess = this.sendMqMessage(executorVo, taskInstShardEo);
        }
        if (!isSendMQSuccess && 1 == taskInstShardEoList.size()) {
            String failReason = "\u4e0b\u53d1\u4efb\u52a1\u6d88\u606f\u5931\u8d25";
            this.modifyTaskInstanceFailed(taskInsId, failReason);
            throw new BusinessRuntimeException("10001", failReason);
        }
    }

    @Override
    public boolean sendMqMessage(TaskExecutorVo executorVo, TaskInstShardEo taskInstShardEo) {
        Long taskInsId = executorVo.getTaskInstId();
        TaskQueryRespDto taskDto = this.taskService.queryById(executorVo.getTaskId());
        AppBizQueryRespDto appBizQueryRespDto = this.appBizService.queryById(taskDto.getAppBizId());
        boolean isSendMQSuccess = true;
        TaskMsg msgContent = new TaskMsg();
        msgContent.setScheduleInstName(executorVo.getScheduleInstName());
        msgContent.setTaskInstShardId(taskInstShardEo.getId());
        msgContent.setTaskInstId(taskInsId);
        msgContent.setTaskId(executorVo.getTaskId());
        msgContent.setTaskBatchInstId(executorVo.getTaskBatchInstId());
        msgContent.setTaskBatchId(executorVo.getTaskBatchId());
        msgContent.setAppCode(appBizQueryRespDto.getAppCode());
        msgContent.setBizCode(appBizQueryRespDto.getBizCode());
        msgContent.setContent(new String(taskInstShardEo.getMsgContent(), StandardCharsets.UTF_8));
        if (TaskInstShardTypeEnum.CLIENT.getCode().equals(taskInstShardEo.getShardType())) {
            msgContent.setIsParallel(TaskMsgParallelEnum.Y.getCode());
        } else {
            msgContent.setIsParallel(TaskMsgParallelEnum.N.getCode());
        }
        msgContent.setRetryType(executorVo.getRetryType());
        executorVo.setTaskInstShardId(taskInstShardEo.getId());
        MessageResponse mqResp = this.retryService.getMessageResponse(appBizQueryRespDto, msgContent, executorVo);
        if (MessageResponse.ERROR.getResultMsg().equals(mqResp.getResultMsg())) {
            isSendMQSuccess = false;
            taskInstShardEo.setStatus(TaskInstShardStatusEnum.EXCP.getCode());
        }
        taskInstShardEo.setMsgId((String)mqResp.getData());
        taskInstShardEo.setTopic(this.mqUtils.getDefaultTopic());
        this.taskInstShardService.modifyTaskInstShard(taskInstShardEo);
        return isSendMQSuccess;
    }

    private List<TaskInstShardEo> splitTask(Long taskInsId, TaskQueryRespDto taskQueryRespDto) {
        ArrayList<TaskInstShardEo> list = new ArrayList<TaskInstShardEo>();
        String paramsStr = taskQueryRespDto.getParams() == null ? "" : taskQueryRespDto.getParams();
        String shardType = taskQueryRespDto.getShardType();
        if ("SINGLE".equals(shardType)) {
            TaskInstShardEo taskInstShardEo = new TaskInstShardEo();
            taskInstShardEo.setTaskInstId(taskInsId);
            taskInstShardEo.setTaskId(taskQueryRespDto.getId());
            taskInstShardEo.setAppBizId(taskQueryRespDto.getAppBizId());
            taskInstShardEo.setShardType(TaskInstShardTypeEnum.SERVER.getCode());
            taskInstShardEo.setTopic("");
            taskInstShardEo.setMsgId("");
            taskInstShardEo.setMsgContent(paramsStr.getBytes(StandardCharsets.UTF_8));
            taskInstShardEo.setStatus(TaskInstShardStatusEnum.RUNNING.getCode());
            list.add(taskInstShardEo);
        } else if ("SERVER".equals(shardType)) {
            String[] paramsList;
            for (String param : paramsList = paramsStr.split(",")) {
                TaskInstShardEo taskInstShardEo = new TaskInstShardEo();
                taskInstShardEo.setTaskInstId(taskInsId);
                taskInstShardEo.setTaskId(taskQueryRespDto.getId());
                taskInstShardEo.setAppBizId(taskQueryRespDto.getAppBizId());
                taskInstShardEo.setShardType(TaskInstShardTypeEnum.SERVER.getCode());
                taskInstShardEo.setTopic("");
                taskInstShardEo.setMsgId("");
                taskInstShardEo.setMsgContent(param.getBytes(StandardCharsets.UTF_8));
                taskInstShardEo.setStatus(TaskInstShardStatusEnum.RUNNING.getCode());
                list.add(taskInstShardEo);
            }
        } else {
            TaskInstShardEo taskInstShardEo = new TaskInstShardEo();
            taskInstShardEo.setTaskInstId(taskInsId);
            taskInstShardEo.setTaskId(taskQueryRespDto.getId());
            taskInstShardEo.setAppBizId(taskQueryRespDto.getAppBizId());
            taskInstShardEo.setShardType(TaskInstShardTypeEnum.CLIENT.getCode());
            taskInstShardEo.setTopic("");
            taskInstShardEo.setMsgId("");
            taskInstShardEo.setMsgContent(paramsStr.getBytes(StandardCharsets.UTF_8));
            taskInstShardEo.setStatus(TaskInstShardStatusEnum.RUNNING.getCode());
            list.add(taskInstShardEo);
        }
        return list;
    }

    private void modifyTaskInstanceFailed(Long taskInsId, String failReason) {
        logger.error(failReason);
        TaskInstUpdateReqDto taskInstUpdateReqDto = new TaskInstUpdateReqDto();
        taskInstUpdateReqDto.setStatus(TaskInstShardStatusEnum.EXCP.getCode());
        taskInstUpdateReqDto.setFailReason(failReason);
        this.modify(taskInsId, taskInstUpdateReqDto);
    }
}

