/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.scheduler.biz.service.impl;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskRelationCreateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.response.TaskRelationQueryRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.response.TaskRelationRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.response.TaskRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.biz.service.ITaskRelationService;
import com.dtyunxi.yundt.cube.center.scheduler.biz.task.TaskExecutor;
import com.dtyunxi.yundt.cube.center.scheduler.common.constants.TaskInstShardStatusEnum;
import com.dtyunxi.yundt.cube.center.scheduler.common.constants.TaskRelationTypeEnum;
import com.dtyunxi.yundt.cube.center.scheduler.common.constants.TaskStatusEnum;
import com.dtyunxi.yundt.cube.center.scheduler.dao.das.TaskBatchDas;
import com.dtyunxi.yundt.cube.center.scheduler.dao.das.TaskBatchInstDas;
import com.dtyunxi.yundt.cube.center.scheduler.dao.das.TaskDas;
import com.dtyunxi.yundt.cube.center.scheduler.dao.das.TaskInstDas;
import com.dtyunxi.yundt.cube.center.scheduler.dao.das.TaskRelationDas;
import com.dtyunxi.yundt.cube.center.scheduler.dao.eo.StdTaskRelationEo;
import com.dtyunxi.yundt.cube.center.scheduler.dao.eo.TaskBatchEo;
import com.dtyunxi.yundt.cube.center.scheduler.dao.eo.TaskBatchInstEo;
import com.dtyunxi.yundt.cube.center.scheduler.dao.eo.TaskEo;
import com.dtyunxi.yundt.cube.center.scheduler.dao.eo.TaskInstEo;
import com.dtyunxi.yundt.cube.center.scheduler.dao.eo.TaskRelationEo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TaskRelationServiceImpl
implements ITaskRelationService {
    private static final Logger logger = LoggerFactory.getLogger(TaskRelationServiceImpl.class);
    @Resource
    private TaskRelationDas taskRelationDas;
    @Resource
    private TaskBatchDas taskBatchDas;
    @Resource
    private TaskDas taskDas;
    @Resource
    private TaskInstDas taskInstDas;
    @Resource
    private TaskBatchInstDas taskBatchInstDas;
    @Resource(name="cubeSchedulerTaskExecutor")
    private TaskExecutor taskExecutor;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addTaskRelation(Long taskBatchId, List<TaskRelationCreateReqDto> addReqDtoList) {
        if (CollectionUtils.isEmpty(addReqDtoList)) {
            throw new BusinessRuntimeException("10002", "\u4efb\u52a1\u5173\u7cfb\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        TaskBatchEo taskBatchEo = (TaskBatchEo)this.taskBatchDas.selectByPrimaryKey(taskBatchId);
        if (taskBatchEo == null) {
            throw new BusinessRuntimeException("11002", "\u6279\u5904\u7406\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        if (!TaskStatusEnum.NEW.getCode().equals(taskBatchEo.getStatus())) {
            throw new BusinessRuntimeException("10002", "\u53ea\u80fd\u4fee\u6539\u72b6\u6001\u4e3a\u65b0\u5efa\u72b6\u6001\u7684\u6279\u5904\u7406\u4efb\u52a1\u5173\u7cfb");
        }
        ArrayList eoList = Lists.newArrayList();
        ArrayList preTaskIdList = null;
        for (TaskRelationCreateReqDto dto : addReqDtoList) {
            ArrayList curPreTaskIdList = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty(preTaskIdList)) {
                curPreTaskIdList.addAll(preTaskIdList);
            }
            preTaskIdList = Lists.newArrayList();
            String taskType = StringUtils.isBlank((CharSequence)dto.getTaskType()) ? TaskRelationTypeEnum.AND.getCode() : dto.getTaskType();
            List taskIdList = dto.getTaskIdList();
            if (CollectionUtils.isEmpty((Collection)taskIdList)) {
                throw new BusinessRuntimeException("10002", "\u4efb\u52a1id\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (eoList.size() == 0) {
                if (taskIdList.size() > 1) {
                    throw new BusinessRuntimeException("10002", "\u6279\u5904\u7406\u53ea\u80fd\u67091\u4e2a\u6839\u8282\u70b9\u4efb\u52a1");
                }
                TaskRelationEo eo = new TaskRelationEo();
                eo.setTaskBatchId(taskBatchId);
                eo.setTaskId((Long)taskIdList.get(0));
                eo.setTaskType(taskType);
                eo.setExtension("");
                eoList.add(eo);
                preTaskIdList.add(taskIdList.get(0));
                continue;
            }
            for (Long taskId : taskIdList) {
                for (Long preTaskId : curPreTaskIdList) {
                    TaskRelationEo eo = new TaskRelationEo();
                    eo.setTaskBatchId(taskBatchId);
                    eo.setTaskId(taskId);
                    eo.setPreTaskId(preTaskId);
                    eo.setTaskType(taskType);
                    eo.setExtension("");
                    eoList.add(eo);
                }
                preTaskIdList.add(taskId);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)eoList)) {
            this.deleteTaskRelation(taskBatchId);
            this.taskRelationDas.insertBatch((List)eoList);
            List<Long> taskIdList = eoList.stream().map(StdTaskRelationEo::getTaskId).collect(Collectors.toList());
            this.setTaskBatchId(taskBatchId, taskIdList);
        }
    }

    private void setTaskBatchId(Long taskBatchId, List<Long> taskIdList) {
        List taskEoList = this.taskDas.selectByIds(taskIdList);
        if (CollectionUtils.isNotEmpty((Collection)taskEoList)) {
            for (TaskEo eo : taskEoList) {
                eo.setTaskBatchId(taskBatchId);
                this.taskDas.updateSelective((BaseEo)eo);
            }
        }
    }

    @Override
    public void deleteTaskRelation(Long taskBatchId) {
        this.taskRelationDas.deleteByTaskBatchId(taskBatchId);
        TaskEo queryEo = new TaskEo();
        queryEo.setTaskBatchId(taskBatchId);
        List taskEoList = this.taskDas.select((BaseEo)queryEo);
        if (CollectionUtils.isNotEmpty((Collection)taskEoList)) {
            for (TaskEo eo : taskEoList) {
                eo.setTaskBatchId(null);
                this.taskDas.update((BaseEo)eo);
            }
        }
    }

    @Override
    public TaskRelationQueryRespDto queryByTaskBatchId(Long taskBatchId) {
        TaskBatchEo taskBatchEo = (TaskBatchEo)this.taskBatchDas.selectByPrimaryKey(taskBatchId);
        if (taskBatchEo == null) {
            throw new BusinessRuntimeException("11002", "\u6279\u5904\u7406\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        TaskRelationQueryRespDto respDto = new TaskRelationQueryRespDto();
        respDto.setTaskBatchId(taskBatchId);
        respDto.setTaskBatchCode(taskBatchEo.getTaskBatchCode());
        respDto.setTaskBatchName(taskBatchEo.getTaskBatchName());
        List eoList = this.taskRelationDas.selectByTaskBatchId(taskBatchId);
        if (CollectionUtils.isEmpty((Collection)eoList)) {
            return respDto;
        }
        List<Object> taskRelationList = Lists.newArrayList();
        taskRelationList = this.getTaskRelationList(null, eoList, taskRelationList, 1, false);
        respDto.setTaskRelationList((List)taskRelationList);
        return respDto;
    }

    private List<TaskRelationRespDto> getTaskRelationList(List<Long> preTaskIdList, List<TaskRelationEo> eoList, List<TaskRelationRespDto> taskRelationList, int callNumber, boolean querySufTaskListOnly) {
        if (callNumber > 10) {
            throw new BusinessRuntimeException("10002", "\u6570\u636e\u5f02\u5e38\uff1a\u6279\u5904\u7406\u4efb\u52a1\u5173\u7cfb\u5b58\u5728\u5faa\u73af\u4f9d\u8d56");
        }
        ArrayList taskIdList = Lists.newArrayList();
        String taskType = null;
        ArrayList taskList = Lists.newArrayList();
        for (TaskRelationEo eo : eoList) {
            boolean hasSufTask = false;
            if (preTaskIdList == null && eo.getPreTaskId() == null) {
                hasSufTask = true;
            }
            if (preTaskIdList != null && preTaskIdList.get(0).equals(eo.getPreTaskId())) {
                hasSufTask = true;
            }
            if (!hasSufTask) continue;
            taskIdList.add(eo.getTaskId());
            taskType = eo.getTaskType();
            TaskRespDto taskRespDto = new TaskRespDto();
            taskRespDto.setTaskId(eo.getTaskId());
            TaskEo taskEo = (TaskEo)this.taskDas.selectByPrimaryKey(eo.getTaskId());
            if (taskEo == null) {
                throw new BusinessRuntimeException("11002", "\u4efb\u52a1\u4e0d\u5b58\u5728");
            }
            taskRespDto.setTaskName(taskEo.getTaskName());
            taskList.add(taskRespDto);
        }
        if (preTaskIdList == null && taskIdList.size() == 0) {
            throw new BusinessRuntimeException("10002", "\u6570\u636e\u5f02\u5e38\uff1a\u6279\u5904\u7406\u6839\u8282\u70b9\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        if (preTaskIdList == null && taskIdList.size() > 1) {
            throw new BusinessRuntimeException("10002", "\u6570\u636e\u5f02\u5e38\uff1a\u6279\u5904\u7406\u53ea\u80fd\u67091\u4e2a\u6839\u8282\u70b9\u4efb\u52a1");
        }
        if (CollectionUtils.isNotEmpty((Collection)taskIdList)) {
            TaskRelationRespDto taskRelationRespDto = new TaskRelationRespDto();
            taskRelationRespDto.setTaskType(taskType);
            taskRelationRespDto.setTaskList((List)taskList);
            taskRelationList.add(taskRelationRespDto);
            if (!querySufTaskListOnly) {
                this.getTaskRelationList(taskIdList, eoList, taskRelationList, ++callNumber, false);
            }
        }
        return taskRelationList;
    }

    @Override
    public TaskRelationRespDto querySufTaskList(Long taskBatchId, List<Long> curTaskIdList) {
        List eoList = this.taskRelationDas.selectByTaskBatchId(taskBatchId);
        if (CollectionUtils.isEmpty((Collection)eoList)) {
            throw new BusinessRuntimeException("10002", "\u6570\u636e\u5f02\u5e38\uff1a\u6279\u5904\u7406\u4efb\u52a1\u5173\u7cfb\u4e0d\u5b58\u5728");
        }
        List<TaskRelationRespDto> taskRelationRespDtoList = this.getTaskRelationList(curTaskIdList, eoList, Lists.newArrayList(), 1, true);
        if (CollectionUtils.isNotEmpty(taskRelationRespDtoList)) {
            return taskRelationRespDtoList.get(0);
        }
        return null;
    }

    @Override
    public void executeTaskBatch(Long taskBatchId, Long taskBatchInstId, Long taskId, String status, String failReason) {
        List preTaskList = this.taskRelationDas.select(taskBatchId, taskId, null);
        if (CollectionUtils.isEmpty((Collection)preTaskList)) {
            throw new BusinessRuntimeException("11002", "\u6570\u636e\u5f02\u5e38\uff1a\u6279\u5904\u7406\u4efb\u52a1\u5173\u7cfb\u4e0d\u5b58\u5728");
        }
        Long preTaskId = null;
        for (TaskRelationEo eo : preTaskList) {
            if (eo.getPreTaskId() == null) continue;
            preTaskId = eo.getPreTaskId();
            break;
        }
        if (preTaskId == null) {
            if (TaskInstShardStatusEnum.SUCCESS.getCode().equals(status)) {
                this.executeSufTask(taskBatchId, taskBatchInstId, taskId);
            } else {
                this.updateTaskBatchInst(taskBatchInstId, TaskInstShardStatusEnum.FAILED.getCode(), failReason);
            }
        } else {
            List curTaskList = this.taskRelationDas.select(taskBatchId, null, preTaskId);
            if (CollectionUtils.isEmpty((Collection)curTaskList)) {
                throw new BusinessRuntimeException("11002", "\u6570\u636e\u5f02\u5e38\uff1a\u6279\u5904\u7406\u4efb\u52a1\u5173\u7cfb\u4e0d\u5b58\u5728");
            }
            if (curTaskList.size() == 1) {
                if (TaskInstShardStatusEnum.SUCCESS.getCode().equals(status)) {
                    this.executeSufTask(taskBatchId, taskBatchInstId, taskId);
                } else {
                    this.updateTaskBatchInst(taskBatchInstId, TaskInstShardStatusEnum.FAILED.getCode(), failReason);
                }
            } else {
                List curTaskIdList = curTaskList.stream().map(StdTaskRelationEo::getTaskId).collect(Collectors.toList());
                List taskInstEoList = this.taskInstDas.selectByTaskIds(taskBatchInstId, curTaskIdList);
                String taskType = ((TaskRelationEo)curTaskList.get(0)).getTaskType();
                if (TaskRelationTypeEnum.OR.equals((Object)taskType)) {
                    if (TaskInstShardStatusEnum.SUCCESS.getCode().equals(status)) {
                        this.executeSufTask(taskBatchId, taskBatchInstId, taskId);
                    } else if (this.isAllDone(taskInstEoList) && this.isAllFail(taskInstEoList)) {
                        this.updateTaskBatchInst(taskBatchInstId, TaskInstShardStatusEnum.FAILED.getCode(), failReason);
                    }
                } else if (TaskInstShardStatusEnum.SUCCESS.getCode().equals(status)) {
                    if (this.isAllDone(taskInstEoList) && this.isAllSuccess(taskInstEoList)) {
                        this.executeSufTask(taskBatchId, taskBatchInstId, taskId);
                    }
                } else {
                    this.updateTaskBatchInst(taskBatchInstId, TaskInstShardStatusEnum.FAILED.getCode(), failReason);
                }
            }
        }
    }

    private void executeSufTask(Long taskBatchId, Long taskBatchInstId, Long taskId) {
        List sufTaskList = this.taskRelationDas.select(taskBatchId, null, taskId);
        if (CollectionUtils.isEmpty((Collection)sufTaskList)) {
            this.updateTaskBatchInst(taskBatchInstId, TaskInstShardStatusEnum.SUCCESS.getCode(), null);
        } else {
            List sufTaskIdList = sufTaskList.stream().map(StdTaskRelationEo::getTaskId).collect(Collectors.toList());
            List taskInstEoList = this.taskInstDas.selectByTaskIds(taskBatchInstId, sufTaskIdList);
            if (CollectionUtils.isEmpty((Collection)taskInstEoList)) {
                for (TaskRelationEo eo : sufTaskList) {
                    try {
                        this.taskExecutor.execute(eo.getTaskId(), null, taskBatchId, taskBatchInstId);
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                }
            }
        }
    }

    private void updateTaskBatchInst(Long taskBatchInstId, String status, String failReason) {
        TaskBatchInstEo taskBatchInstEo = (TaskBatchInstEo)this.taskBatchInstDas.selectByPrimaryKey(taskBatchInstId);
        if (taskBatchInstEo == null) {
            throw new BusinessRuntimeException("11002", "\u6570\u636e\u5f02\u5e38\uff1a\u6279\u5904\u7406\u4efb\u52a1\u5b9e\u4f8b\u4e0d\u5b58\u5728");
        }
        taskBatchInstEo.setStatus(status);
        taskBatchInstEo.setFailReason(failReason);
        this.taskBatchInstDas.updateSelective((BaseEo)taskBatchInstEo);
    }

    private boolean isAllDone(List<TaskInstEo> taskInstEoList) {
        for (TaskInstEo eo : taskInstEoList) {
            if (!TaskInstShardStatusEnum.RUNNING.getCode().equals(eo.getStatus())) continue;
            return false;
        }
        return true;
    }

    private boolean isAllFail(List<TaskInstEo> taskInstEoList) {
        for (TaskInstEo eo : taskInstEoList) {
            if (!TaskInstShardStatusEnum.SUCCESS.getCode().equals(eo.getStatus())) continue;
            return false;
        }
        return true;
    }

    private boolean isAllSuccess(List<TaskInstEo> taskInstEoList) {
        for (TaskInstEo eo : taskInstEoList) {
            if (!TaskInstShardStatusEnum.FAILED.getCode().equals(eo.getStatus()) && !TaskInstShardStatusEnum.EXCP.getCode().equals(eo.getStatus())) continue;
            return false;
        }
        return true;
    }
}

