/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.scheduler.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskAndBizCreateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskCreateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskQueryReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskUpdateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.response.AppBizQueryRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.response.TaskQueryRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.biz.service.IQuartzService;
import com.dtyunxi.yundt.cube.center.scheduler.biz.service.ITaskService;
import com.dtyunxi.yundt.cube.center.scheduler.common.constants.TaskStatusEnum;
import com.dtyunxi.yundt.cube.center.scheduler.dao.das.AppBizDas;
import com.dtyunxi.yundt.cube.center.scheduler.dao.das.TaskDas;
import com.dtyunxi.yundt.cube.center.scheduler.dao.eo.AppBizEo;
import com.dtyunxi.yundt.cube.center.scheduler.dao.eo.TaskEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.quartz.CronExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TaskServiceImpl
implements ITaskService {
    private static Logger logger = LoggerFactory.getLogger(TaskServiceImpl.class);
    @Resource
    private TaskDas taskDas;
    @Resource
    private AppBizDas appBizDas;
    @Resource
    private IQuartzService quartzService;
    @Resource
    private ILockService lockService;

    @Override
    public TaskQueryRespDto queryById(Long id) {
        TaskEo eo = new TaskEo();
        eo.setId(id);
        eo = (TaskEo)this.taskDas.selectOne((BaseEo)eo);
        if (eo == null) {
            throw new BusinessRuntimeException("11002", "\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        TaskQueryRespDto dto = new TaskQueryRespDto();
        DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)dto);
        AppBizEo appBizEo = (AppBizEo)this.appBizDas.selectByPrimaryKey(eo.getAppBizId());
        if (appBizEo != null) {
            AppBizQueryRespDto bizQueryRespDto = new AppBizQueryRespDto();
            CubeBeanUtils.copyProperties((Object)bizQueryRespDto, (Object)appBizEo, (String[])new String[0]);
            dto.setAppBizRespDto(bizQueryRespDto);
        }
        return dto;
    }

    @Override
    public PageInfo<TaskQueryRespDto> queryByPage(TaskQueryReqDto taskQueryReqDto, Integer pageNum, Integer pageSize) {
        ArrayList<SqlFilter> filters;
        String appCode = StringUtils.isNotBlank((CharSequence)taskQueryReqDto.getAppCode()) ? taskQueryReqDto.getAppCode().trim() : null;
        String bizName = StringUtils.isNotBlank((CharSequence)taskQueryReqDto.getBizName()) ? taskQueryReqDto.getBizName().trim() : null;
        List appBizIdList = null;
        if (appCode != null || bizName != null) {
            List appBizEoList;
            AppBizEo appBizEo = new AppBizEo();
            appBizEo.setAppCode(appCode);
            if (bizName != null) {
                filters = new ArrayList();
                filters.add(SqlFilter.like((String)"biz_name", (Object)("%" + bizName + "%")));
                appBizEo.setSqlFilters(filters);
                appBizEo.setBizName(null);
            }
            if (CollectionUtils.isNotEmpty((Collection)(appBizEoList = this.appBizDas.select((BaseEo)appBizEo)))) {
                appBizIdList = appBizEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
            } else {
                return new PageInfo();
            }
        }
        TaskEo eo = new TaskEo();
        DtoHelper.dto2Eo((BaseVo)taskQueryReqDto, (BaseEo)eo);
        filters = new ArrayList<SqlFilter>();
        if (taskQueryReqDto.getStartTime() != null) {
            filters.add(SqlFilter.ge((String)"update_time", (Object)taskQueryReqDto.getStartTime()));
        }
        if (taskQueryReqDto.getEndTime() != null) {
            filters.add(SqlFilter.lt((String)"update_time", (Object)taskQueryReqDto.getEndTime()));
        }
        if ("true".equals(taskQueryReqDto.getSetTaskRelation())) {
            filters.add(SqlFilter.isNull((String)"task_batch_id"));
            eo.setTaskBatchId(null);
            eo.setStatus(TaskStatusEnum.NEW.getCode());
        }
        if (StringUtils.isNotBlank((CharSequence)taskQueryReqDto.getTaskName())) {
            filters.add(SqlFilter.like((String)"task_name", (Object)("%" + taskQueryReqDto.getTaskName() + "%")));
            eo.setTaskName(null);
        }
        if (CollectionUtils.isNotEmpty(appBizIdList)) {
            filters.add(SqlFilter.in((String)"app_biz_id", (Object)StringUtils.join(appBizIdList, (String)",")));
            eo.setAppBizId(null);
        }
        eo.setSqlFilters(filters);
        eo.setOrderByDesc("update_time");
        PageInfo eoPageInfo = this.taskDas.selectPage((BaseEo)eo, pageNum, pageSize);
        ArrayList dtoList = new ArrayList();
        PageInfo dtoPageInfo = new PageInfo(dtoList);
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, TaskQueryRespDto.class);
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        for (TaskQueryRespDto taskQueryRespDto : dtoPageInfo.getList()) {
            AppBizEo appBizEo = (AppBizEo)this.appBizDas.selectByPrimaryKey(taskQueryRespDto.getAppBizId());
            if (appBizEo == null) continue;
            AppBizQueryRespDto bizQueryRespDto = new AppBizQueryRespDto();
            CubeBeanUtils.copyProperties((Object)bizQueryRespDto, (Object)appBizEo, (String[])new String[0]);
            taskQueryRespDto.setAppBizRespDto(bizQueryRespDto);
        }
        return dtoPageInfo;
    }

    @Override
    public Long add(TaskCreateReqDto taskCreateReqDto) {
        AppBizEo appBizEo = (AppBizEo)this.appBizDas.selectByPrimaryKey(taskCreateReqDto.getAppBizId());
        if (appBizEo == null) {
            throw new BusinessRuntimeException("11002", "\u5e94\u7528\u4e1a\u52a1ID\u4e0d\u5b58\u5728");
        }
        if (TaskStatusEnum.DISABLE.getCode().equals(appBizEo.getStatus())) {
            throw new BusinessRuntimeException("10002", "Task\u4e3a\u7981\u7528\u72b6\u6001\uff0c\u4e0d\u80fd\u65b0\u589eJob");
        }
        TaskEo eo = new TaskEo();
        eo.setTaskBatchId(taskCreateReqDto.getTaskBatchId());
        eo.setAppBizId(taskCreateReqDto.getAppBizId());
        if (StringUtils.isNotBlank((CharSequence)taskCreateReqDto.getTaskName())) {
            eo.setTaskName(taskCreateReqDto.getTaskName());
            if (this.taskDas.count((BaseEo)eo) > 0) {
                throw new BusinessRuntimeException("11001", "\u4efb\u52a1\u91cd\u590d");
            }
        }
        eo.setTaskName(null);
        int count = this.taskDas.count((BaseEo)eo);
        StringBuilder taskCode = new StringBuilder().append(appBizEo.getAppCode()).append("_").append(appBizEo.getBizCode()).append("_").append(++count);
        if (!CronExpression.isValidExpression((String)taskCreateReqDto.getScheduleExpression())) {
            throw new BusinessRuntimeException("10002", "cron\u8868\u8fbe\u5f0f\u9519\u8bef");
        }
        DtoHelper.dto2Eo((BaseVo)taskCreateReqDto, (BaseEo)eo);
        eo.setTaskCode(taskCode.toString());
        eo.setStatus(TaskStatusEnum.NEW.getCode());
        if (StringUtils.isBlank((CharSequence)eo.getTaskName())) {
            eo.setTaskName(taskCode.toString());
        }
        this.taskDas.insert((BaseEo)eo);
        return eo.getId();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Long addWithBiz(TaskAndBizCreateReqDto taskAndBizCreateReqDto) {
        AppBizEo appBizEo = new AppBizEo();
        appBizEo.setAppCode(taskAndBizCreateReqDto.getAppCode());
        appBizEo.setBizCode(taskAndBizCreateReqDto.getBizCode());
        if (this.appBizDas.count((BaseEo)appBizEo) > 0) {
            appBizEo = (AppBizEo)this.appBizDas.selectOne((BaseEo)appBizEo);
        } else {
            Mutex mutex = null;
            String mutexKey = taskAndBizCreateReqDto.getAppCode() + "_" + taskAndBizCreateReqDto.getBizCode();
            try {
                mutex = this.lockService.lock("appBiz", mutexKey, 3, 3, TimeUnit.SECONDS);
                if (this.appBizDas.count((BaseEo)appBizEo) > 0) {
                    appBizEo = (AppBizEo)this.appBizDas.selectOne((BaseEo)appBizEo);
                } else {
                    DtoHelper.dto2Eo((BaseVo)taskAndBizCreateReqDto, (BaseEo)appBizEo);
                    appBizEo.setStatus(TaskStatusEnum.ENABLE.getCode());
                    this.appBizDas.insert((BaseEo)appBizEo);
                }
            }
            catch (Exception e) {
                try {
                    throw e;
                }
                catch (Throwable throwable) {
                    this.lockService.unlock(mutex);
                    throw throwable;
                }
            }
            this.lockService.unlock(mutex);
        }
        TaskEo eo = new TaskEo();
        eo.setTaskBatchId(taskAndBizCreateReqDto.getTaskBatchId());
        eo.setAppBizId(appBizEo.getId());
        eo.setTaskName(taskAndBizCreateReqDto.getTaskName());
        if (this.taskDas.count((BaseEo)eo) > 0) {
            throw new BusinessRuntimeException("11001", "\u4efb\u52a1\u91cd\u590d");
        }
        StringBuilder taskCode = null;
        if (StringUtils.isNotBlank((CharSequence)taskAndBizCreateReqDto.getTaskCode())) {
            eo.setTaskName(null);
            eo.setTaskCode(taskAndBizCreateReqDto.getTaskCode());
            if (this.taskDas.count((BaseEo)eo) > 0) {
                throw new BusinessRuntimeException("11001", "\u4efb\u52a1\u7f16\u7801\u91cd\u590d");
            }
            taskCode = new StringBuilder().append(appBizEo.getAppCode()).append("_").append(appBizEo.getBizCode()).append("_").append(taskAndBizCreateReqDto.getTaskCode());
        }
        if (!CronExpression.isValidExpression((String)taskAndBizCreateReqDto.getScheduleExpression())) {
            throw new BusinessRuntimeException("10002", "cron\u8868\u8fbe\u5f0f\u9519\u8bef");
        }
        DtoHelper.dto2Eo((BaseVo)taskAndBizCreateReqDto, (BaseEo)eo);
        eo.setStatus(TaskStatusEnum.NEW.getCode());
        if (taskCode != null) {
            eo.setTaskCode(taskCode.toString());
        }
        this.taskDas.insert((BaseEo)eo);
        return eo.getId();
    }

    @Override
    public void modify(Long id, TaskUpdateReqDto taskUpdateReqDto) {
        Mutex mutex = null;
        try {
            mutex = this.lockService.lock("task", "" + id, 3, 3, TimeUnit.SECONDS);
            TaskEo eo = new TaskEo();
            eo.setId(id);
            if (this.taskDas.count((BaseEo)eo) < 1) {
                throw new BusinessRuntimeException("11002", "\u4efb\u52a1ID\u4e0d\u5b58\u5728");
            }
            String scheduleExpression = taskUpdateReqDto.getScheduleExpression();
            if (StringUtils.isNotBlank((CharSequence)scheduleExpression) && !CronExpression.isValidExpression((String)scheduleExpression)) {
                throw new BusinessRuntimeException("10002", "cron\u8868\u8fbe\u5f0f\u9519\u8bef");
            }
            DtoHelper.dto2Eo((BaseVo)taskUpdateReqDto, (BaseEo)eo);
            this.taskDas.updateSelective((BaseEo)eo);
            eo = (TaskEo)this.taskDas.selectByPrimaryKey(id);
            if (TaskStatusEnum.ENABLE.getCode().equals(eo.getStatus())) {
                this.quartzService.rescheduleJob(eo.getScheduleExpression(), "" + eo.getId(), "" + eo.getId());
            }
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                this.lockService.unlock(mutex);
                throw throwable;
            }
        }
        this.lockService.unlock(mutex);
    }

    @Override
    @Transactional
    public void remove(Long id) {
        Mutex mutex = null;
        try {
            mutex = this.lockService.lock("task", "" + id, 3, 3, TimeUnit.SECONDS);
            TaskEo eo = (TaskEo)this.taskDas.selectByPrimaryKey(id);
            if (eo == null) {
                throw new BusinessRuntimeException("11002", "\u4efb\u52a1ID\u4e0d\u5b58\u5728");
            }
            if (TaskStatusEnum.ENABLE.getCode().equals(eo.getStatus())) {
                throw new BusinessRuntimeException("\u4efb\u52a1\u542f\u7528\u4e2d\uff0c\u4e0d\u53ef\u5220\u9664");
            }
            this.taskDas.logicDelete((BaseEo)eo);
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                this.lockService.unlock(mutex);
                throw throwable;
            }
        }
        this.lockService.unlock(mutex);
    }

    @Override
    public void enable(Long id) {
        Mutex mutex = null;
        try {
            mutex = this.lockService.lock("task", "" + id, 3, 3, TimeUnit.SECONDS);
            TaskEo eo = (TaskEo)this.taskDas.selectByPrimaryKey(id);
            if (eo == null) {
                throw new BusinessRuntimeException("11002", "\u4efb\u52a1ID\u4e0d\u5b58\u5728");
            }
            if (TaskStatusEnum.ENABLE.getCode().equals(eo.getStatus())) {
                throw new BusinessRuntimeException("\u4efb\u52a1\u72b6\u6001\u4e0d\u6b63\u786e");
            }
            if (eo.getTaskBatchId() != null) {
                throw new BusinessRuntimeException("10002", "\u6279\u5904\u7406\u5185\u4efb\u52a1\u4e0d\u80fd\u5355\u72ec\u542f\u52a8");
            }
            TaskEo updateEo = new TaskEo();
            updateEo.setId(id);
            updateEo.setStatus(TaskStatusEnum.ENABLE.getCode());
            this.taskDas.updateSelective((BaseEo)updateEo);
            this.quartzService.scheduleJob(eo.getScheduleExpression(), "" + eo.getId(), "" + eo.getId());
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                this.lockService.unlock(mutex);
                throw throwable;
            }
        }
        this.lockService.unlock(mutex);
    }

    @Override
    public void disable(Long id) {
        Mutex mutex = null;
        try {
            mutex = this.lockService.lock("task", "" + id, 3, 3, TimeUnit.SECONDS);
            TaskEo eo = (TaskEo)this.taskDas.selectByPrimaryKey(id);
            if (eo == null) {
                throw new BusinessRuntimeException("11002", "\u4efb\u52a1ID\u4e0d\u5b58\u5728");
            }
            if (TaskStatusEnum.DISABLE.getCode().equals(eo.getStatus())) {
                throw new BusinessRuntimeException("\u4efb\u52a1\u72b6\u6001\u4e0d\u6b63\u786e");
            }
            TaskEo updateEo = new TaskEo();
            updateEo.setId(id);
            updateEo.setStatus(TaskStatusEnum.DISABLE.getCode());
            this.taskDas.updateSelective((BaseEo)updateEo);
            this.quartzService.deleteJob("" + eo.getId(), "" + eo.getId());
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                this.lockService.unlock(mutex);
                throw throwable;
            }
        }
        this.lockService.unlock(mutex);
    }
}

