/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.scheduler.biz.service.impl;

import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskStatReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.response.AppBizQueryRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.response.TaskStatRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.biz.service.IAppBizService;
import com.dtyunxi.yundt.cube.center.scheduler.biz.service.ITaskStatService;
import com.dtyunxi.yundt.cube.center.scheduler.biz.vo.TaskInstStatVo;
import com.dtyunxi.yundt.cube.center.scheduler.common.constants.TaskInstShardStatusEnum;
import com.dtyunxi.yundt.cube.center.scheduler.common.constants.TaskStatusEnum;
import com.dtyunxi.yundt.cube.center.scheduler.dao.das.TaskDas;
import com.dtyunxi.yundt.cube.center.scheduler.dao.das.TaskInstDas;
import com.dtyunxi.yundt.cube.center.scheduler.dao.eo.TaskEo;
import com.dtyunxi.yundt.cube.center.scheduler.dao.eo.TaskInstEo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class TaskStatServiceImpl
implements ITaskStatService {
    @Resource
    private TaskDas taskDas;
    @Resource
    private TaskInstDas taskInstDas;
    @Resource
    private IAppBizService appBizService;
    private static final String HOUR = "hour";
    private static final String DAY = "day";

    @Override
    public TaskStatRespDto stat(TaskStatReqDto taskStatReqDto) {
        String timeUnit = this.getTimeUnit(taskStatReqDto);
        List<Object> taskIdList = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)taskStatReqDto.getAppCode()) && CollectionUtils.isEmpty((Collection)(taskIdList = this.getTaskIdList(taskStatReqDto.getAppCode())))) {
            return new TaskStatRespDto();
        }
        List<TaskInstEo> taskInstEoList = this.getTaskInstEoList(taskStatReqDto, timeUnit, taskIdList);
        List<String> xList = this.initXList(taskStatReqDto, timeUnit);
        TaskStatRespDto taskStatRespDto = new TaskStatRespDto();
        Integer taskCount = this.getTaskCount(taskIdList);
        Integer schedulerCount = this.getSchedulerCount(taskIdList, null);
        Integer taskInstCount = this.getSchedulerCount(taskIdList, TaskInstShardStatusEnum.RUNNING.getCode());
        taskStatRespDto.setTaskCount(Long.valueOf(taskCount.intValue()));
        taskStatRespDto.setTaskInstCount(Long.valueOf(taskInstCount.intValue()));
        taskStatRespDto.setSchedulerCount(Long.valueOf(schedulerCount.intValue()));
        taskStatRespDto.setxList(xList);
        ArrayList taskInstStatList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(taskInstEoList)) {
            ArrayList taskInstStatVoList = Lists.newArrayList();
            for (TaskInstEo eo2 : taskInstEoList) {
                TaskInstStatVo vo = new TaskInstStatVo();
                vo.setId(eo2.getId());
                vo.setStatus(eo2.getStatus());
                vo.setHour(DateUtil.getDateFormat((Date)eo2.getCreateTime(), (String)"HH"));
                vo.setDay(DateUtil.getDateFormat((Date)eo2.getCreateTime(), (String)"yyyy-MM-dd"));
                taskInstStatVoList.add(vo);
            }
            Map<String, List<TaskInstStatVo>> statusMap = taskInstStatVoList.stream().filter(eo -> StringUtils.isNotBlank((CharSequence)eo.getStatus())).collect(Collectors.groupingBy(TaskInstStatVo::getStatus));
            TaskStatRespDto.TaskInstStatRespDto successDto = this.getTaskInstStatRespDto(statusMap, TaskInstShardStatusEnum.SUCCESS.getText(), new String[]{TaskInstShardStatusEnum.SUCCESS.getCode()}, xList, timeUnit);
            TaskStatRespDto.TaskInstStatRespDto failDto = this.getTaskInstStatRespDto(statusMap, TaskInstShardStatusEnum.FAILED.getText(), new String[]{TaskInstShardStatusEnum.FAILED.getCode(), TaskInstShardStatusEnum.EXCP.getCode()}, xList, timeUnit);
            TaskStatRespDto.TaskInstStatRespDto runningDto = this.getTaskInstStatRespDto(statusMap, TaskInstShardStatusEnum.RUNNING.getText(), new String[]{TaskInstShardStatusEnum.RUNNING.getCode()}, xList, timeUnit);
            taskInstStatList.add(successDto);
            taskInstStatList.add(failDto);
            taskInstStatList.add(runningDto);
        }
        taskStatRespDto.setTaskInstStatList((List)taskInstStatList);
        return taskStatRespDto;
    }

    private Integer getSchedulerCount(List<Long> taskIdList, String status) {
        TaskInstEo instEo = new TaskInstEo();
        if (StringUtils.isNotBlank((CharSequence)status)) {
            instEo.setStatus(status);
        }
        if (CollectionUtils.isNotEmpty(taskIdList)) {
            ArrayList<SqlFilter> filters = new ArrayList<SqlFilter>();
            filters.add(SqlFilter.in((String)"task_id", (Object)StringUtils.join(taskIdList, (String)",")));
            instEo.setSqlFilters(filters);
        }
        return this.taskInstDas.count((BaseEo)instEo);
    }

    private Integer getTaskCount(List<Long> taskIdList) {
        TaskEo taskEo = new TaskEo();
        taskEo.setStatus(TaskStatusEnum.ENABLE.getCode());
        if (CollectionUtils.isNotEmpty(taskIdList)) {
            ArrayList<SqlFilter> filters = new ArrayList<SqlFilter>();
            filters.add(SqlFilter.in((String)"id", (Object)StringUtils.join(taskIdList, (String)",")));
            taskEo.setSqlFilters(filters);
        }
        return this.taskDas.count((BaseEo)taskEo);
    }

    private String getTimeUnit(TaskStatReqDto taskStatReqDto) {
        Date endDate;
        String beginTime = taskStatReqDto.getBeginTime();
        String endTime = taskStatReqDto.getEndTime();
        if (StringUtils.isBlank((CharSequence)beginTime)) {
            throw new BusinessRuntimeException("10002", "\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)endTime)) {
            throw new BusinessRuntimeException("10002", "\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Date beginDate = DateUtil.parseDate((String)beginTime, (String)"yyyy-MM-dd HH:mm:ss");
        if (beginDate.after(endDate = DateUtil.parseDate((String)endTime, (String)"yyyy-MM-dd HH:mm:ss"))) {
            throw new BusinessRuntimeException("10002", "\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4");
        }
        if (DateUtil.getDateFormat((Date)beginDate, (String)"yyyy-MM-dd").equals(DateUtil.getDateFormat((Date)endDate, (String)"yyyy-MM-dd"))) {
            return HOUR;
        }
        return DAY;
    }

    private List<Long> getTaskIdList(String appCode) {
        List<AppBizQueryRespDto> appBizQueryRespDtoList = this.appBizService.queryByAppCode(appCode);
        if (CollectionUtils.isNotEmpty(appBizQueryRespDtoList)) {
            List appBizIdList = appBizQueryRespDtoList.stream().map(AppBizQueryRespDto::getId).collect(Collectors.toList());
            List taskEoList = this.taskDas.selectByAppBizIds(appBizIdList);
            if (CollectionUtils.isNotEmpty((Collection)taskEoList)) {
                return taskEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
            }
            return Lists.newArrayList();
        }
        return Lists.newArrayList();
    }

    private List<TaskInstEo> getTaskInstEoList(TaskStatReqDto taskStatReqDto, String timeUnit, List<Long> taskIdList) {
        TaskInstEo taskInstEo = new TaskInstEo();
        ArrayList<SqlFilter> filters = new ArrayList<SqlFilter>();
        if (CollectionUtils.isNotEmpty(taskIdList)) {
            filters.add(SqlFilter.in((String)"task_id", (Object)StringUtils.join(taskIdList, (String)",")));
        }
        if (HOUR.equals(timeUnit)) {
            filters.add(SqlFilter.ge((String)"create_time", (Object)DateUtil.parseDate((String)taskStatReqDto.getBeginTime(), (String)"yyyy-MM-dd")));
            filters.add(SqlFilter.lt((String)"create_time", (Object)DateUtil.addDays((Date)DateUtil.parseDate((String)taskStatReqDto.getBeginTime(), (String)"yyyy-MM-dd"), (int)1)));
        } else if (DAY.equals(timeUnit)) {
            filters.add(SqlFilter.ge((String)"create_time", (Object)taskStatReqDto.getBeginTime()));
            filters.add(SqlFilter.lt((String)"create_time", (Object)taskStatReqDto.getEndTime()));
        }
        taskInstEo.setSqlFilters(filters);
        return this.taskInstDas.select((BaseEo)taskInstEo, Integer.valueOf(1), Integer.valueOf(this.taskInstDas.count((BaseEo)taskInstEo)));
    }

    private List<String> initXList(TaskStatReqDto taskStatReqDto, String timeUnit) {
        ArrayList xList = Lists.newArrayList();
        if (HOUR.equals(timeUnit)) {
            for (int i = 1; i <= 24; ++i) {
                xList.add(String.valueOf(i));
            }
        } else if (DAY.equals(timeUnit)) {
            Date beginTime = DateUtil.parseDate((String)taskStatReqDto.getBeginTime(), (String)"yyyy-MM-dd");
            Date endTime = DateUtil.parseDate((String)taskStatReqDto.getEndTime(), (String)"yyyy-MM-dd");
            while (beginTime.before(endTime)) {
                xList.add(DateUtil.formatDate((DatePattern)DatePattern.DATE_PATTERN, (Date)beginTime));
                beginTime = DateUtil.addDays((Date)beginTime, (int)1);
            }
            xList.add(DateUtil.formatDate((DatePattern)DatePattern.DATE_PATTERN, (Date)endTime));
        }
        return xList;
    }

    private TaskStatRespDto.TaskInstStatRespDto getTaskInstStatRespDto(Map<String, List<TaskInstStatVo>> statusMap, String statusDesc, String[] queryStatus, List<String> xList, String timeUint) {
        List<TaskInstStatVo> list;
        TaskStatRespDto.TaskInstStatRespDto taskInstStatRespDto = new TaskStatRespDto.TaskInstStatRespDto();
        taskInstStatRespDto.setStatus(statusDesc);
        ArrayList countDetail = Lists.newArrayList();
        ArrayList taskInstStatVoList = Lists.newArrayList();
        for (String status : queryStatus) {
            list = statusMap.get(status);
            if (!CollectionUtils.isNotEmpty(list)) continue;
            taskInstStatVoList.addAll(list);
        }
        if (CollectionUtils.isNotEmpty((Collection)taskInstStatVoList)) {
            Map<String, List<TaskInstStatVo>> hourMap = taskInstStatVoList.stream().collect(Collectors.groupingBy(TaskInstStatVo::getHour));
            Map<String, List<TaskInstStatVo>> dayMap = taskInstStatVoList.stream().collect(Collectors.groupingBy(TaskInstStatVo::getDay));
            for (String x : xList) {
                if (HOUR.equals(timeUint)) {
                    int i = Integer.parseInt(x);
                    String hour = i - 1 < 10 ? "0" + (i - 1) : "" + (i - 1);
                    list = hourMap.get(hour);
                } else {
                    list = dayMap.get(x);
                }
                if (CollectionUtils.isEmpty(list)) {
                    countDetail.add(0);
                    continue;
                }
                countDetail.add(list.size());
            }
            taskInstStatRespDto.setCount(Integer.valueOf(taskInstStatVoList.size()));
        } else {
            taskInstStatRespDto.setCount(Integer.valueOf(0));
        }
        taskInstStatRespDto.setCountDetail((List)countDetail);
        return taskInstStatRespDto;
    }
}

