/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.scheduler.biz.task;

import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.response.TaskInstQueryRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.biz.service.ITaskInstService;
import com.dtyunxi.yundt.cube.center.scheduler.biz.service.ITaskInstShardService;
import com.dtyunxi.yundt.cube.center.scheduler.biz.vo.RetryVo;
import com.dtyunxi.yundt.cube.center.scheduler.biz.vo.TaskExecutorVo;
import com.dtyunxi.yundt.cube.center.scheduler.common.constants.TaskInstShardStatusEnum;
import com.dtyunxi.yundt.cube.center.scheduler.dao.das.TaskBatchInstDas;
import com.dtyunxi.yundt.cube.center.scheduler.dao.eo.TaskBatchInstEo;
import com.dtyunxi.yundt.cube.center.scheduler.dao.eo.TaskInstShardEo;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="retryTaskExecutor")
public class RetryTaskExecutor {
    private static final Logger logger = LoggerFactory.getLogger(RetryTaskExecutor.class);
    @Autowired
    private ITaskInstService taskInstService;
    @Autowired
    private TaskBatchInstDas taskBatchInstDas;
    @Autowired
    private ITaskInstShardService taskInstShardService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(RetryVo retryVo) {
        if (retryVo.getTaskInstShardId() == null) {
            Long taskInstId = retryVo.getTaskInstId();
            TaskInstQueryRespDto taskInstDto = this.taskInstService.queryById(taskInstId);
            if (!TaskInstShardStatusEnum.EXCP.getCode().equals(taskInstDto.getStatus()) && !TaskInstShardStatusEnum.FAILED.getCode().equals(taskInstDto.getStatus())) throw new BusinessRuntimeException("10001", "\u4efb\u52a1\u5b9e\u4f8b\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u505c\u6b62\u91cd\u8bd5 | taskInstId = " + taskInstId);
            TaskExecutorVo executorVo = this.buildTaskExecutorVo(retryVo);
            TaskInstShardEo queryEo = new TaskInstShardEo();
            queryEo.setTaskInstId(taskInstId);
            List<TaskInstShardEo> taskInstShardEoList = this.taskInstShardService.queryByEo(queryEo);
            if (CollectionUtils.isNotEmpty(taskInstShardEoList)) {
                for (TaskInstShardEo eo : taskInstShardEoList) {
                    if (!TaskInstShardStatusEnum.FAILED.getCode().equals(eo.getStatus()) && !TaskInstShardStatusEnum.EXCP.getCode().equals(eo.getStatus())) continue;
                    this.taskInstService.sendMqMessage(executorVo, eo);
                }
                return;
            } else {
                this.taskInstService.taskInstExecute(executorVo);
            }
            return;
        } else {
            Long taskInstShardId = retryVo.getTaskInstShardId();
            TaskInstShardEo taskInstShardEo = this.taskInstShardService.selectById(taskInstShardId);
            if (!TaskInstShardStatusEnum.EXCP.getCode().equals(taskInstShardEo.getStatus()) && !TaskInstShardStatusEnum.FAILED.getCode().equals(taskInstShardEo.getStatus())) throw new BusinessRuntimeException("10001", "\u4efb\u52a1\u5b9e\u4f8b\u5206\u7247\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u505c\u6b62\u91cd\u8bd5 | taskInstShardId = " + taskInstShardId);
            retryVo.setTaskInstId(taskInstShardEo.getTaskInstId());
            TaskExecutorVo executorVo = this.buildTaskExecutorVo(retryVo);
            boolean isSendMQSuccess = this.taskInstService.sendMqMessage(executorVo, taskInstShardEo);
            if (isSendMQSuccess) return;
            String failReason = "\u4e0b\u53d1\u4efb\u52a1\u6d88\u606f\u5931\u8d25";
            throw new BusinessRuntimeException("10001", failReason);
        }
    }

    private TaskExecutorVo buildTaskExecutorVo(RetryVo retryVo) {
        Long taskInstId = retryVo.getTaskInstId();
        TaskInstQueryRespDto taskInstDto = this.taskInstService.queryById(taskInstId);
        Long taskBatchId = null;
        if (taskInstDto.getTaskBatchInstId() != null) {
            TaskBatchInstEo taskBatchInstEo = (TaskBatchInstEo)this.taskBatchInstDas.selectByPrimaryKey(taskInstDto.getTaskBatchInstId());
            taskBatchId = taskBatchInstEo == null ? null : taskBatchInstEo.getTaskBatchId();
        }
        TaskExecutorVo executorVo = new TaskExecutorVo(taskInstDto.getTaskId(), retryVo.getScheduleInstName(), taskBatchId, taskInstDto.getTaskBatchInstId(), taskInstId);
        executorVo.setTaskInstShardId(retryVo.getTaskInstShardId());
        executorVo.setRetryType(retryVo.getRetryType());
        return executorVo;
    }
}

