/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.scheduler.biz.task;

import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.response.AppBizQueryRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.response.TaskQueryRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.biz.service.IAppBizService;
import com.dtyunxi.yundt.cube.center.scheduler.biz.service.ITaskInstService;
import com.dtyunxi.yundt.cube.center.scheduler.biz.service.ITaskInstShardService;
import com.dtyunxi.yundt.cube.center.scheduler.biz.service.ITaskService;
import com.dtyunxi.yundt.cube.center.scheduler.biz.utils.MqUtils;
import com.dtyunxi.yundt.cube.center.scheduler.biz.vo.TaskExecutorVo;
import com.dtyunxi.yundt.cube.center.scheduler.biz.vo.TaskInstVo;
import com.dtyunxi.yundt.cube.center.scheduler.common.constants.TaskInstShardStatusEnum;
import com.dtyunxi.yundt.cube.center.scheduler.common.constants.TaskStatusEnum;
import com.dtyunxi.yundt.cube.center.scheduler.dao.das.TaskBatchDas;
import com.dtyunxi.yundt.cube.center.scheduler.dao.das.TaskBatchInstDas;
import com.dtyunxi.yundt.cube.center.scheduler.dao.eo.TaskBatchEo;
import com.dtyunxi.yundt.cube.center.scheduler.dao.eo.TaskBatchInstEo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="cubeSchedulerTaskExecutor")
public class TaskExecutor {
    private static final Logger logger = LoggerFactory.getLogger(TaskExecutor.class);
    @Autowired
    ITaskService taskService;
    @Autowired
    IAppBizService appBizService;
    @Autowired
    ITaskInstService taskInstService;
    @Autowired
    ITaskInstShardService taskInstShardService;
    @Autowired
    ICacheService cacheService;
    @Autowired
    ICommonsMqService commonsMqService;
    @Autowired
    MqUtils mqUtils;
    @Autowired
    TaskBatchDas taskBatchDas;
    @Autowired
    TaskBatchInstDas taskBatchInstDas;

    public RestResponse<Long> execute(Long taskId, String scheduleInstName, Long taskBatchId, Long taskBatchInstId) {
        if (!taskId.equals(taskBatchId)) {
            logger.info("\u6267\u884c\u6279\u5904\u7406\u4efb\u52a1 | taskBatchId = " + taskBatchId);
            TaskBatchEo taskBatchEo = (TaskBatchEo)this.taskBatchDas.selectByPrimaryKey(taskBatchId);
            if (taskBatchEo == null) {
                throw new BusinessRuntimeException("11002", "\u6279\u5904\u7406\u8bb0\u5f55\u4e0d\u5b58\u5728 | taskBatchId = " + taskBatchId);
            }
            if (!TaskStatusEnum.ENABLE.getCode().equals(taskBatchEo.getStatus())) {
                throw new BusinessRuntimeException("10001", "\u6279\u5904\u7406\u4efb\u52a1\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u505c\u6b62\u6267\u884c | taskBatchId = " + taskBatchId);
            }
        }
        logger.info("\u6267\u884c\u4efb\u52a1 | taskId = " + taskId);
        TaskQueryRespDto taskDto = this.taskService.queryById(taskId);
        if (taskDto == null) {
            throw new BusinessRuntimeException("11002", "\u4efb\u52a1\u4e0d\u5b58\u5728 | taskId = " + taskId);
        }
        if (taskId.equals(taskBatchId) && !TaskStatusEnum.ENABLE.getCode().equals(taskDto.getStatus())) {
            throw new BusinessRuntimeException("10001", "\u4efb\u52a1\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u505c\u6b62\u6267\u884c | taskId = " + taskId);
        }
        Long appBizId = taskDto.getAppBizId();
        AppBizQueryRespDto appBizQueryRespDto = this.appBizService.queryById(appBizId);
        if (appBizQueryRespDto == null) {
            throw new BusinessRuntimeException("11002", "\u5e94\u7528\u4e1a\u52a1\u4e0d\u5b58\u5728 | appBizId = " + appBizId);
        }
        if (!taskId.equals(taskBatchId) && taskBatchInstId == null) {
            TaskBatchInstEo taskBatchInstEo = new TaskBatchInstEo();
            taskBatchInstEo.setTaskBatchId(taskBatchId);
            taskBatchInstEo.setStatus(TaskInstShardStatusEnum.RUNNING.getCode());
            this.taskBatchInstDas.insert((BaseEo)taskBatchInstEo);
            taskBatchInstId = taskBatchInstEo.getId();
        }
        TaskInstVo taskInstDto = new TaskInstVo();
        taskInstDto.setStatus(TaskInstShardStatusEnum.RUNNING.getCode());
        taskInstDto.setTaskBatchInstId(taskBatchInstId);
        Long taskInsId = this.taskInstService.add(taskId, taskInstDto);
        TaskExecutorVo executorVo = new TaskExecutorVo(taskId, scheduleInstName, taskBatchId, taskBatchInstId, taskInsId);
        this.taskInstService.taskInstExecute(executorVo);
        return new RestResponse((Object)taskInsId);
    }
}

