/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.scheduler.biz.utils;

import com.dtyunxi.cube.plugin.mq.TopicRegistryVo;
import com.dtyunxi.huieryun.mq.constant.MessageType;
import com.dtyunxi.huieryun.mq.vo.MessageRegistryVo;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class MqUtils {
    private static final Logger logger = LoggerFactory.getLogger(MqUtils.class);
    @Autowired
    private MessageRegistryVo messageRegistryVo;
    @Value(value="${spring.profiles.active}")
    private String profile;
    @Resource
    private Environment environment;
    @Value(value="${dtyunxi.env.module}")
    private String envModule;
    @Autowired
    private TopicRegistryVo topicRegistryVo;

    private String parseStringWithProfile(String str) {
        String profile = this.environment.getProperty("cube.global.profile");
        if (StringUtils.isBlank((CharSequence)profile)) {
            profile = this.profile;
        }
        return (str + "_" + profile).replace("-", "_").toUpperCase();
    }

    private String parseTag(String tag) {
        if (MessageType.RABBIT.getName().equalsIgnoreCase(this.messageRegistryVo.getType())) {
            tag = this.parseStringWithProfile(tag);
        }
        return tag;
    }

    public TopicRegistryVo getTopicRegistryVo() {
        return this.topicRegistryVo;
    }

    public String getDefaultTopic() {
        return this.parseStringWithProfile(this.topicRegistryVo.getSingleTopic());
    }
}

