package com.dtyunxi.yundt.cube.center.data.limit.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.request.DataLimitRuleTmplConfigReqDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.request.DataLimitRuleTmplCreateReqDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.request.DataLimitRuleTmplModifyReqDto;
import com.dtyunxi.yundt.cube.center.data.limit.api.dto.request.RuleTmplConfigReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
* 数据权限规则模板服务接口
*
* @author 代码生成器
*/
@Api(tags = {"用户中心：数据权限规则模板服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-user-api-IDataLimitRuleTmplApi",
        path = "/v1/data-limit-rule/tmpl",
        name = "${dtyunxi.yundt.cube_base-center-user_api.name:base-center-user}",
        url = "${dtyunxi.yundt.cube_base-center-user_api:}"
)
public interface IDataLimitRuleTmplApi {

    /**
    * 新增数据权限规则模板
    *
    * @param addReqDto 数据权限规则模板请求对象
    * @return 处理结果
    */
    @PostMapping("")
    @ApiOperation(value = "新增数据权限规则模板", notes = "新增数据权限规则模板")
    RestResponse<Long> addDataLimitRuleTmpl(@RequestBody DataLimitRuleTmplCreateReqDto addReqDto);

    /**
    * 修改数据权限规则模板
    *
    * @param modifyReqDto 数据权限规则模板请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改数据权限规则模板", notes = "修改数据权限规则模板")
    RestResponse<Void> modifyDataLimitRuleTmpl(@RequestBody DataLimitRuleTmplModifyReqDto modifyReqDto);

    /**
    * 删除数据权限规则模板
    *
    * @param id        数据权限规则模板ID
    * @return 处理结果
    */
    @DeleteMapping("/{id}")
    @ApiOperation(value = "删除数据权限规则模板", notes = "删除数据权限规则模板")
    RestResponse<Void> removeDataLimitRuleTmpl(@PathVariable("id") Long id);

}
