/**
 * @(#) SortEnum.java 1.0 2020-06-01
 * <p>
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.data.limit.api.constant;

/**
 * 脱敏规则枚举
 *
 * @author 仪琳
 * @since 1.0.0
 */
public enum DesenRuleEnum {
    ASTERISK_REPLACE(1, "星号替换"),
    USER_NAME_DESEN(2, "姓名脱敏"),
    PHONE_DESEN(3, "手机号脱敏"),
    EMAIL_DESEN(4, "邮箱脱敏"),
    ID_CARD_DESEN(5, "身份证脱敏")
    ;

    private Integer type;
    private String desc;

    DesenRuleEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static String getDescByType(Integer type) {
        if (type == null) {
            return null;
        }
        for (DesenRuleEnum sort : DesenRuleEnum.values()) {
            if (type.equals(sort.getType())) {
                return sort.getDesc();
            }
        }
        return null;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
