/**
 * @(#) SortEnum.java 1.0 2020-06-01
 * <p>
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.data.limit.api.constant;

import org.springframework.util.StringUtils;

import java.util.EnumSet;

/**
 * 数据权限身份类型枚举
 *
 * @author 仪琳
 * @since 1.0.0
 */
public enum IdentityTypeEnum {
    /**
     * 角色
     */
    ROLE("role", "角色");

    private String code;
    private String desc;

    IdentityTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static String getDescByCode(String code) {
        if (StringUtils.isEmpty(code)) {
            return null;
        }
        for (IdentityTypeEnum sort : IdentityTypeEnum.values()) {
            if (code.toLowerCase().equals(sort.getCode())) {
                return sort.getDesc();
            }
        }
        return null;
    }

    /**
     * 根据code获取枚举
     *
     * @param code code
     * @return 枚举
     */
    public static IdentityTypeEnum fromCode(String code) {
        for (IdentityTypeEnum anEnum : EnumSet.allOf(IdentityTypeEnum.class)) {
            if (anEnum.getCode().equals(code)) {
                return anEnum;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
