/**
 * @(#) SortEnum.java 1.0 2020-06-01
 * <p>
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.data.limit.api.constant;

import org.springframework.util.StringUtils;

/**
 * 逻辑运算符类型枚举
 *
 * @author 仪琳
 * @since 1.0.0
 */
public enum LogicalOperatorEnum {

    EQ("=", "等于"),
    NE("!=", "不等于"),
    GT(">", "大于"),
    LT("<", "小于"),
    GE(">=", "大于等于"),
    LE("<=", "小于等于"),
    LIKE("LIKE", "like"),
    IN("IN", "包含"),
    NOTIN("NOT IN", "不包含")
    ;

    private String code;
    private String desc;

    LogicalOperatorEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static String getDescByCode(String code) {
        if (StringUtils.isEmpty(code)) {
            return null;
        }
        for (LogicalOperatorEnum sort : LogicalOperatorEnum.values()) {
            if (code.toUpperCase().equals(sort.getCode())) {
                return sort.getDesc();
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
