package com.dtyunxi.yundt.cube.center.meta.sql.api.query;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.meta.sql.api.dto.req.MetaQueryBodyReq;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 根据元数据查询实体数据，对查询进行JSON配置化
 *
 * @author ganguo.ggw@dtyunxi.com
 */
@Api(tags = {"元数据：根据元数据查询实体数据"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-user-api-MetaToEntityQueryApi",
        path = "/v1/meta-entity",
        name = "${dtyunxi.yundt.cube_base-center-user_api.name:base-center-user}",
        url = "${dtyunxi.yundt.cube_base-center-user_api:}"
)
public interface MetaToEntityQueryApi {
    /**
     * 案例1： like 查询
     *{"columns": ["id", "user_name"],
     * "table": "us_user",
     * "params": {"user_name@like": "hua%"}
     * }
     * @param queryBodyReq
     * @return
     */
    @PostMapping("/queryPage")
    @ApiOperation(value = "分页查询实体数据", notes = "分页查询实体数据")
    RestResponse<PageInfo<JSONObject>> queryPage(@RequestBody MetaQueryBodyReq queryBodyReq);

}
