/**
 * @(#)IAuthorizeApi.java 1.0 2018/6/20
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 用户身份认证ApiAPI接口
 *
 * @author 伊泽
 * @since 1.0.0
 */
/*
 *  身份认证接口涉及内容：
 *  1、 随机生成4位数字作为验证码，调用通信组件，通过手机号码或邮箱的方式发送给用户，并将验证码暂时先保存到数据库（验证码类型字段用来区分是绑定邮箱还是绑定手机）
 *  2、 通过验证码类型匹配调用哪个通信组件，并将传递过来的验证码与数据库的验证码对比，匹配成功则绑定相应的内容
 * */
@Api(tags = {"用户中心：身份认证"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-user-api-IAuthorizeApi",path = "/v1/authorize", name = "${dtyunxi.yundt.cube_base-center-user_api.name:base-center-user}", url = "${dtyunxi.yundt.cube_base-center-user_api:}")
public interface IAuthorizeApi {

    /**
     * 手机绑定
     *
     * @param instanceId 应用Id
     * @param userId     用户id
     * @param phone      手机号码
     * @return Long
     */
    @ApiOperation(value = "手机绑定", notes = "手机绑定")
    @PutMapping(value = "/{instanceId}/bindPhoneNew", produces = {"application/json;charset=UTF-8"})
    @Capability(capabilityCode = "user.authorize.bind-phone")
    RestResponse<Long> bindPhone(@PathVariable("instanceId") Long instanceId,
                                 @RequestParam("userId") Long userId,
                                 @RequestParam("phone") String phone);

    /**
     * 手机解绑
     *
     * @param instanceId 应用Id
     * @param userId     用户id
     * @param phone      手机号
     * @return Long
     */
    @ApiOperation(value = "手机解绑", notes = "手机解绑")
    @PutMapping(value = "/{instanceId}/unbindPhoneNew", produces = {"application/json;charset=UTF-8"})
    @Capability(capabilityCode = "user.authorize.unbind-phone")
    RestResponse<Long> unbindPhone(@PathVariable("instanceId") Long instanceId,
                                   @RequestParam("userId") Long userId,
                                   @RequestParam("phone") String phone);

    /**
     * 邮箱绑定
     *
     * @param instanceId 应用Id
     * @param userId     用户id
     * @param email      邮箱
     * @return Long
     */
    @ApiOperation(value = "邮箱绑定", notes = "邮箱绑定")
    @PutMapping(value = "/{instanceId}/bindEmailNew", produces = {"application/json;charset=UTF-8"})
    @Capability(capabilityCode = "user.authorize.bind-email")
    RestResponse<Long> bindEmail(@PathVariable("instanceId") Long instanceId, @RequestParam("userId") Long userId,
                                 @RequestParam("email") String email);

    /**
     * 邮箱解绑
     *
     * @param instanceId 应用Id
     * @param userId     用户id
     * @param email      邮箱
     * @return Long
     */
    @ApiOperation(value = "邮箱解绑", notes = "邮箱解绑")
    @PutMapping(value = "/{instanceId}/unbindEmailNew", produces = {"application/json;charset=UTF-8"})
    @Capability(capabilityCode = "user.authorize.unbind-email")
    RestResponse<Long> unbindEmail(@PathVariable("instanceId") Long instanceId, @RequestParam("userId") Long userId,
                                   @RequestParam("email") String email);

}
