/**
 * @(#) IPersonalInfoQueryApi.java 1.0 2019/1/18
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.RoleDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

/**
 * 授权服务
 * create By qiudao on 2019/6/20
 */
@Api(tags = {"用户中心：授权服务拓展"})
@FeignClient(
        contextId="com-dtyunxi-yundt-cube-center-user-api-IBizAccessApi",
        path = "/v1/access",
        name = "${dtyunxi.yundt.cube_base-center-user_api.name:base-center-user}",
        url = "${dtyunxi.yundt.cube_base-center-user_api:}"
)
public interface IBizAccessApi {

    /**
     * 新增角色
     * @param instanceId 实例ID
     * @return
     */
    @PostMapping(value = {"/{instanceId}/role/add"}, produces = "application/json")
    @ApiOperation(value = "新增角色", notes = "新增角色")
    @Capability(capabilityCode = "user.biz-access.add-role")
    RestResponse<Long> addRole(@PathVariable("instanceId") Long instanceId, @Valid @RequestBody RoleDto roleDto);

    /**
     * 删除角色
     * @param id
     * @return
     */
    @DeleteMapping(value = {"/role/delete/{id}"}, produces = "application/json")
    @ApiOperation(value = "删除角色", notes = "删除角色")
    @Capability(capabilityCode = "user.biz-access.delete-role")
    RestResponse<Void> deleteRole(@PathVariable("id") Long id);

}
