/**
 * @(#)IExtensionApi.java 1.0 May 17, 2018
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved. YUNXI
 * PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * 用户属性扩展服务API接口
 *
 * @author 南枫
 * @since 1.0.0
 */
@Api(tags = {"用户中心：属性扩展服务，支持User、Person的扩展"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-user-api-IExtensionApi",path = "/v1/extension", name = "${dtyunxi.yundt.cube_base-center-user_api.name:base-center-user}", url = "${dtyunxi.yundt.cube_base-center-user_api:}")
public interface IExtensionApi {

    /**
     * 添加表扩展属性
     *
     * @param objectName  对象名称
     * @param id          记录主键
     * @param extraParams 扩展参数属性及值，内容格式为JSON格式
     * @return Long
     */
    @RequestMapping(value = "/{objectName}/{id}", method = RequestMethod.POST)
    @ApiOperation(value = "扩展对象属性", notes = "请求参数为：\n\t objectName:对象名  \n\t id:主键Id")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "objectName", value = "对象名称", dataType = "string", paramType = "path", required = true),
            @ApiImplicitParam(name = "id", value = "对象主键Id", dataType = "long", paramType = "path", required = true),
            @ApiImplicitParam(name = "extraParams", value = "扩展属性", required = true)})
    @Capability(capabilityCode = "user.extension.add-table-extra-property")
    RestResponse<Long> addTableExtraProperty(@PathVariable("objectName") String objectName, @PathVariable("id") Long id,
                                             @RequestBody String extraParams);

    /**
     * 修改表扩展属性
     *
     * @param objectName  对象名称
     * @param id          记录主键
     * @param extraParams 扩展参数属性及值，内容格式为JSON格式
     * @return Long
     */
    @RequestMapping(value = "/{objectName}/{id}", method = RequestMethod.PUT)
    @ApiOperation(value = "修改对象扩展属性", notes = "请求参数为：\n\t objectName:对象名  \n\t id:主键Id")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "objectName", value = "对象名称", dataType = "string", paramType = "path", required = true),
            @ApiImplicitParam(name = "id", value = "对象主键Id", dataType = "long", paramType = "path", required = true),
            @ApiImplicitParam(name = "extraParams", value = "扩展属性", required = true)})
    @Capability(capabilityCode = "user.extension.update-table-extra-property")
    RestResponse<Long> updateTableExtraProperty(@PathVariable("objectName") String objectName,
                                                @PathVariable("id") Long id, @RequestBody String extraParams);

    /**
     * 查找表扩展属性
     *
     * @param objectName 对象名称
     * @param id         主键Id
     * @return String
     */
    @RequestMapping(value = "/{objectName}/{id}", method = RequestMethod.GET)
    @ApiOperation(value = "查找对象扩展属性", notes = "请求参数为：\n\t objectName:对象名  \n\t id:主键Id")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "objectName", value = "对象名称", dataType = "string", paramType = "path", required = true),
            @ApiImplicitParam(name = "id", value = "对象主键Id", dataType = "long", paramType = "path", required = true),
            @ApiImplicitParam(name = "filter", value = "filter，此查询参数无效", dataType = "string", paramType = "query", required = true)
    })
    @Capability(capabilityCode = "user.extension.find")
    RestResponse<String> find(@PathVariable("objectName") String objectName, @PathVariable("id") Long id, @RequestParam("filter") String filter);

    @RequestMapping(value = "/{objectName}/{id}", method = RequestMethod.DELETE)
    @ApiOperation(value = "删除对象扩展属性", notes = "请求参数为：\n\t objectName:对象名  \n\t id:主键Id")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "objectName", value = "对象名称", dataType = "string", paramType = "path", required = true),
            @ApiImplicitParam(name = "id", value = "对象主键Id", dataType = "long", paramType = "path", required = true)})
    @Capability(capabilityCode = "user.extension.delete-table-extra-property")
    RestResponse<Void> deleteTableExtraProperty(@PathVariable("objectName") String objectName, @PathVariable("id") Long id);
}
