/**
 * @(#)IApplicationApi.java 1.0 May 17, 2018
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.AppInstanceDomainRemoveDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.AppInstanceDomainReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.application.DataInstanceStatusUpdateReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 用户应用服务API接口
 *
 * @author 悠扬
 * @since 2.6.22
 */
@Api(tags = {"用户中心：应用"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-user-api-IInstanceApi",path = "/v1/instance", name = "${dtyunxi.yundt.cube_base-center-user_api.name:base-center-user}", url = "${dtyunxi.yundt.cube_base-center-user_api:}")
public interface IInstanceApi {
    /**
     * 修改应用的数据初始状态
     *
     * @param dto 修改请求
     * @return Boolean
     */
    @PutMapping(value = "/data-init-status", produces = {"application/json;charset=UTF-8"})
    @ApiOperation(value = "修改应用的数据初始状态", notes = "修改应用的数据初始状态, instanceId通过HttpHeade指定")
    @Capability(capabilityCode = "user.instance.modify-data-init-status")
    RestResponse<Boolean> modifyDataInitStatus(@RequestBody DataInstanceStatusUpdateReqDto dto);


    /**
     * 设置应用的帐号域
     *
     * @param appInstanceDomainReqDto 设置应用的帐号域
     * @return
     */
    @PostMapping(value = "/user-domain")
    @ApiOperation(value = "设置应用的帐号域", notes = "设置应用的帐号域。" +
            "如果应用对应的默认帐号域为空，则应用默认帐号域为default")
    @Capability(capabilityCode = "user.instance.set-app-instance-domain")
    RestResponse<Void> setAppInstanceDomain(@RequestBody AppInstanceDomainReqDto appInstanceDomainReqDto);

    /**
     * 删除应用的指定帐号域
     *
     * @param appInstanceDomainRemoveDto 删除应用的指定帐号域请求
     * @return
     */
    @DeleteMapping(value = "/user-domain")
    @ApiOperation(value = "删除应用的指定帐号域", notes = "删除应用的指定帐号域。" +
            "如果应用对应的默认帐号域为空，则应用默认帐号域为default")
    @Capability(capabilityCode = "user.instance.remove-app-instance-domain")
    RestResponse<Void> removeAppInstanceDomain(@SpringQueryMap AppInstanceDomainRemoveDto appInstanceDomainRemoveDto);
}
