/**
 * @(#) IPersonalInfoApi.java 1.0 2019/1/18
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.PersonalInfoExtDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.validation.Valid;

/**
 * @author 米修
 * @date 2019/1/18
 * @since 1.0.0
 */
@Api(tags = {"用户中心：个人信息管理"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-user-api-IPersonalInfoApi",path = "/v1/personal-info", name = "${dtyunxi.yundt.cube_base-center-user_api.name:base-center-user}", url = "${dtyunxi.yundt.cube_base-center-user_api:}")
public interface IPersonalInfoApi {

    /**
     * 新增个人信息
     * @param personInfoExtDto 个人信息dto
     * @return
     */
    @RequestMapping(value = "", produces = "application/json", method = RequestMethod.POST)
    @ApiOperation(value = "新增个人信息", notes = "新增个人信息")
    @Capability(capabilityCode = "user.personal-info.add-personal-info")
    RestResponse<Long> addPersonalInfo(@Valid @RequestBody PersonalInfoExtDto personInfoExtDto);

    /**
     * 更新个人信息
     * @param id 个人信息id
     * @param personalInfoExtDto  个人信息dto
     * @return
     */
    @RequestMapping(value = "/{id}", produces = "application/json", method = RequestMethod.PUT)
    @ApiOperation(value = "更新个人信息", notes = "更新个人信息")
    @Capability(capabilityCode = "user.personal-info.update-personal-info")
    RestResponse<Void> updatePersonalInfo(@PathVariable("id") Long id, @Valid @RequestBody PersonalInfoExtDto personalInfoExtDto);


}
