/**
 * @(#)ISecurityApi.java 1.0 2018/6/20
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserModifyPasswordDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserResetPasswordDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * 用户账号安全服务API接口
 *
 * @author 南枫
 * @since 1.0.0
 */
@Api(tags = {"用户中心：账号安全服务"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-user-api-ISecurityApi",path = "/v1/security", name = "${dtyunxi.yundt.cube_base-center-user_api.name:base-center-user}", url = "${dtyunxi.yundt.cube_base-center-user_api:}")
public interface ISecurityApi {

    /**
     * 根据用户id查询唯一用户， md5加密password和用户中的密码比较，成功就md5新密码，存入用户信息
     * 修改用户密码
     *
     * @param userModifyPasswordDto    修改用户密码请求dto
     * @return void
     */
    @RequestMapping(value = "/user-password", method = RequestMethod.PUT)
    @ApiOperation(value = "修改用户密码", notes = "instanceId实例ID userName 用户名" +
            "password 旧密码 newPassword 新密码 domain 账号域")
    @Capability(capabilityCode = "user.security.modify-password")
    RestResponse<Void> modifyPassword(@RequestBody UserModifyPasswordDto userModifyPasswordDto);

    /**
     * 根据用户id查询唯一用户， md5加密password和用户中的密码比较，成功就md5新密码，存入用户信息
     * 修改用户密码
     *
     * @param userName    用户账号
     * @param password    用户密码
     * @param newPassword 新密码
     * @param instanceId  实例ID
     * @return void
     */
    @Deprecated
    @RequestMapping(value = "/{instanceId}", method = RequestMethod.PUT)
    @ApiOperation(value = "修改用户密码", notes = "instanceId实例ID userName 用户名" +
            "password 旧密码 newPassword 新密码  ；用/v1/security/user-password代替")
    @Capability(capabilityCode = "user.security.modify-password")
    RestResponse<Void> modifyPassword(@PathVariable("instanceId") Long instanceId,
                                      @RequestParam("userName") String userName,
                                      @RequestParam("password") String password,
                                      @RequestParam("newPassword") String newPassword);

    /**
     * 根据用户id查询唯一用户， md5加密password和用户中的密码比较，成功就md5新密码，存入用户信息
     * 修改用户密码
     *
     * @param userName    用户账号
     * @param password    用户密码
     * @param newPassword 新密码
     * @return void
     * @see ISecurityApi#modifyPassword(Long, String, String, String)
     */
    @Deprecated
    @RequestMapping(value = "", method = RequestMethod.PUT)
    @ApiOperation(value = "修改用户密码，使用/v1/security/{instanceId}代替", notes = "userName 用户名" +
            "password 旧密码 newPassword 新密码")
    @Capability(capabilityCode = "user.security.modify-password")
    RestResponse<Void> modifyPassword(@RequestParam("userName") String userName,
                                      @RequestParam("password") String password,
                                      @RequestParam("newPassword") String newPassword);


    /**
     * 根据手机或邮箱验证码重置用户密码 (target 为手机号或邮箱)
     *
     * @param userResetPasswordDto  重置用户密码请求dto
     * @return void
     */
    @RequestMapping(value = "/user/by-verify-code", method = RequestMethod.PUT)
    @ApiOperation(value = "根据手机或邮箱验证码重置用户密码", notes = "根据手机或邮箱验证码重置用户密码 (target 为手机号或邮箱)")
    @Capability(capabilityCode = "user.security.reset-password")
    RestResponse<Void> resetPassword(@RequestBody UserResetPasswordDto userResetPasswordDto);



    /**
     * 根据手机或邮箱验证码重置用户密码 (target 为手机号或邮箱)
     *
     * @param verifyCode  验证码
     * @param target      目标
     * @param newPassword 新密码
     * @param instanceId  实例ID
     * @return void
     */
    @Deprecated
    @RequestMapping(value = "/user/{instanceId}/{verifyCode}", method = RequestMethod.PUT)
    @ApiOperation(value = "根据手机或邮箱验证码重置用户密码", notes = "根据手机或邮箱验证码重置用户密码 (target 为手机号或邮箱)")
    @Capability(capabilityCode = "user.security.reset-password")
    RestResponse<Void> resetPassword(@PathVariable("instanceId") Long instanceId,
                                     @PathVariable("verifyCode") String verifyCode,
                                     @RequestParam("target") String target,
                                     @RequestParam("newPassword") String newPassword);


    /**
     * 根据手机或邮箱验证码重置用户密码 (target 为手机号或邮箱)
     *
     * @param verifyCode  验证码
     * @param target      目标
     * @param newPassword 新密码
     * @return void
     * @see ISecurityApi#resetPassword(Long, String, String, String)
     */
    @Deprecated
    @RequestMapping(value = "/user/{verifyCode}", method = RequestMethod.PUT)
    @ApiOperation(value = "根据手机或邮箱验证码重置用户密码，使用/v1/security/user/{instanceId}/{verifyCode}代替", notes = "根据手机或邮箱验证码重置用户密码 (target 为手机号或邮箱)")
    @Capability(capabilityCode = "user.security.reset-password")
    RestResponse<Void> resetPassword(@PathVariable("verifyCode") String verifyCode,
                                     @RequestParam("target") String target,
                                     @RequestParam("newPassword") String newPassword);

    /**
     * 管理员重置用户密码
     *
     * @param userId      用户ID
     * @param newPassword 新密码
     * @return void
     */
    @RequestMapping(value = "/admin/user/{userId}/password", method = RequestMethod.PUT)
    @ApiOperation(value = "管理员重置用户密码", notes = "管理员重置用户密码")
    @Capability(capabilityCode = "user.security.reset-password-by-admin")
    RestResponse<Void> resetPasswordByAdmin(@PathVariable("userId") Long userId, @RequestParam("newPassword") String newPassword);

}
