/**
 * @(#)IUserInfoApi.java 1.0 May 17, 2018
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.*;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.DeviceReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;


/*
 * 用户信息管理接口涉及内容： 1、对某个用户进行新增、修改个人信息 2、对某个用户进行新增、修改所属组织信息 3、对某个用户进行新增、修改发票信息
 * 4、对某个用户进行新增、修改联系人信息 5、对某个用户进行新增、修改地址信息 6、查询接口另外处理
 */

/**
 * 用户信息管理服务API接口
 *
 * @author 伊泽
 * @since 1.0.0
 */
@Api(tags = {"用户中心：用户信息管理"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-user-api-IUserInfoApi",path = "/v1/user-info", name = "${dtyunxi.yundt.cube_base-center-user_api.name:base-center-user}", url = "${dtyunxi.yundt.cube_base-center-user_api:}")
public interface IUserInfoApi {
    /**
     * 新增用户个人信息
     *
     * @param personalInfoDto 用户个人信息
     * @param userId          用户ID,所属用户的ID
     * @return Long
     */
    @RequestMapping(value = "/user/{userId}/personal-info", produces = "application/json", method = RequestMethod.POST)
    @ApiOperation(value = "新增用户个人信息", notes = "新增用户个人信息 \t\n userId：用户ID，personalInfoDto：用户个人信息Dto")
    @Capability(capabilityCode = "user.user-info.add-personal-info")
    RestResponse<Long> addPersonalInfo(@NotNull @PathVariable("userId") Long userId,
                                       @Valid @RequestBody PersonalInfoDto personalInfoDto);

    /**
     * 修改用户个人信息，其中tenantId,instanceId不能被修改
     *
     * @param userId          所属用户的ID
     * @param personalInfoId  用户个人信息Id
     * @param personalInfoDto 用户个人信息
     * @return Long
     */
    @RequestMapping(value = "/user/{userId}/personal-info/{personalInfoId}", produces = "application/json", method = RequestMethod.PUT)
    @ApiOperation(value = "修改用户个人信息", notes = "修改用户个人信息，其中tenantId,instanceId不能被修改\t\n userId：用户ID，personalInfoId：用户个人信息ID，personalInfoDto：用户个人信息Dto")
    @Capability(capabilityCode = "user.user-info.update-personal-info")
    RestResponse<Long> updatePersonalInfo(@NotNull @PathVariable("userId") Long userId,
                                          @NotNull @PathVariable("personalInfoId") Long personalInfoId,
                                          @Valid @RequestBody PersonalInfoDto personalInfoDto);

    /**
     * 新增所属组织信息(功能包分离删除API)
     *
     * @param organizationInfoDto 用户所属组织信息
     * @param userId              用户的ID
     * @return Long
     */
    /*
    @RequestMapping(value = "/user/{userId}/org-info", produces = "application/json", method = RequestMethod.POST)
    @ApiOperation(value = "新增用户所属组织信息", notes = "新增用户所属组织信息 \t\n userId：用户ID，organizationInfoDto：组织信息")
    @Capability(capabilityCode = "user.user-info.add-org-info")
    RestResponse<Long> addOrgInfo(@NotNull @PathVariable("userId") Long userId,
                                  @Valid @RequestBody OrganizationInfoDto organizationInfoDto);*/

    /**
     * 修改所属组织信息(功能包分离删除API)
     *
     * @param userId              用户的ID
     * @param orgInfoId           组织信息Id
     * @param organizationInfoDto 用户所属组织信息
     * @return Long
     */
    /*
    @RequestMapping(value = "/user/{userId}/org-info/{orgInfoId}", produces = "application/json", method = RequestMethod.PUT)
    @ApiOperation(value = "修改用户所属组织信息", notes = "修改用户所属组织信息 \t\n userId：用户ID，orgInfoId：组织信息ID，organizationInfoDto：组织信息")
    @Capability(capabilityCode = "user.user-info.update-org-info")
    RestResponse<Long> updateOrgInfo(@NotNull @PathVariable("userId") Long userId,
                                     @NotNull @PathVariable("orgInfoId") Long orgInfoId,
                                     @Valid @RequestBody OrganizationInfoDto organizationInfoDto);*/

    /**
     * 新增开票信息
     *
     * @param billInfoDto 用户开票信息
     * @param userId      用户的ID
     * @return Long
     */
    @RequestMapping(value = "/user/{userId}/bill", produces = "application/json", method = RequestMethod.POST)
    @ApiOperation(value = "新增用户开票信息", notes = "新增用户开票信息 \t\n userId：用户ID，billInfoDto：开票信息")
    @Capability(capabilityCode = "user.user-info.add-bill-info")
    RestResponse<Long> addBillInfo(@NotNull @PathVariable("userId") Long userId,
                                   @Valid @RequestBody BillInfoDto billInfoDto);

    /**
     * 修改开票信息
     *
     * @param userId      用户的ID
     * @param billInfoId  用户开票Id
     * @param billInfoDto 用户开票信息
     * @return Long
     */
    @RequestMapping(value = "/user/{userId}/bill/{billInfoId}", produces = "application/json", method = RequestMethod.PUT)
    @ApiOperation(value = "修改用户开票信息", notes = "修改用户开票信息 \t\n userId：用户ID，billInfoId：用户开票信息ID，billInfoDto：开票信息")
    @Capability(capabilityCode = "user.user-info.update-bill-info")
    RestResponse<Long> updateBillInfo(@NotNull @PathVariable("userId") Long userId,
                                      @NotNull @PathVariable("billInfoId") Long billInfoId,
                                      @Valid @RequestBody BillInfoDto billInfoDto);

    /**
     * 删除开票信息
     *
     * @param billInfoId 用户开票Id
     * @return Long
     */
    @RequestMapping(value = "/invoice-title/{billInfoId}", produces = "application/json", method = RequestMethod.DELETE)
    @ApiOperation(value = "删除用户开票信息", notes = "删除用户开票信息 \t\n billInfoId：用户开票信息ID")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "billInfoId", value = "用户开票Id", dataType = "long", paramType = "path", required = true)
    })
    @Capability(capabilityCode = "user.user-info.delete-bill-info")
    RestResponse<Void> deleteBillInfo(@PathVariable("billInfoId") Long billInfoId);

    /**
     * 设置为默认开票抬头
     *
     * @param userInvoiceTitleDto 开票信息
     * @return void
     */
    @RequestMapping(value = {"/bill/to/default"}, produces = "application/json", method = RequestMethod.PUT)
    @ApiOperation(value = "设置默认开票信息", notes = "设置默认开票信息,每个用户下的开票信息只有一个是默认的")
    @ApiImplicitParam(name = "userInvoiceTitleDto", value = "开票信息", dataType = "UserInvoiceTitleDto", paramType = "body", required = true)
    @Capability(capabilityCode = "user.user-info.set-default-invoice-title")
    RestResponse<Void> setDefaultInvoiceTitle(@RequestBody UserInvoiceTitleDto userInvoiceTitleDto);

    /**
     * 新增联系人信息
     *
     * @param contactsInfoDto 用户联系人信息
     * @param userId          用户的ID
     * @return Long
     */
    @RequestMapping(value = "/user/{userId}/contact", produces = "application/json", method = RequestMethod.POST)
    @ApiOperation(value = "新增用户联系人信息", notes = "新增用户联系人信息 \t\n userId：用户ID，contactsInfoDto：联系人信息")
    @Capability(capabilityCode = "user.user-info.add-contacts-info")
    RestResponse<Long> addContactsInfo(@NotNull @PathVariable("userId") Long userId,
                                       @Valid @RequestBody ContactsInfoDto contactsInfoDto);

    /**
     * 修改联系人信息
     *
     * @param userId          用户的ID
     * @param contactId       联系人Id
     * @param contactsInfoDto 联系人信息
     * @return Long
     */
    @RequestMapping(value = "/user/{userId}/contact/{contactId}", produces = "application/json", method = RequestMethod.PUT)
    @ApiOperation(value = "修改用户联系人信息", notes = "修改用户联系人信息 \t\n userId：用户ID，contactId联系人ID，contactsInfoDto：联系人信息")
    @Capability(capabilityCode = "user.user-info.update-contacts-info")
    RestResponse<Long> updateContactsInfo(@NotNull @PathVariable("userId") Long userId,
                                          @PathVariable("contactId") Long contactId,
                                          @Valid @RequestBody ContactsInfoDto contactsInfoDto);

    /**
     * 删除联系人信息
     *
     * @param contactsId 联系人信息的ID
     * @return Long
     * @see IUserInfoApi#deleteContactsInfoByUserIdAndContactsId(Long, Long)
     */
    @Deprecated
    @RequestMapping(value = "/contact/{contactsId}", produces = "application/json", method = RequestMethod.DELETE)
    @ApiOperation(value = "删除用户联系人信息，使用/v1/user-info/user/{userId}/contact/{contactsId}代替", notes = "删除用户联系人信息")
    @Capability(capabilityCode = "user.user-info.delete-contacts-info")
    RestResponse<Long> deleteContactsInfo(@PathVariable("contactsId") Long contactsId);

    /**
     * 删除联系人信息
     *
     * @param userId     用户ID
     * @param contactsId 联系人信息的ID
     * @return Long
     */
    @RequestMapping(value = "/user/{userId}/contact/{contactsId}", produces = "application/json", method = RequestMethod.DELETE)
    @ApiOperation(value = "删除用户联系人信息", notes = "删除用户联系人信息 \t\n userId：用户ID contactsId：联系人信息ID")
    @Capability(capabilityCode = "user.user-info.delete-contacts-info-by-user-id-and-contacts-id")
    RestResponse<Long> deleteContactsInfoByUserIdAndContactsId(@PathVariable("userId") Long userId, @PathVariable("contactsId") Long contactsId);

    /**
     * 新增地址信息
     *
     * @param addressDto 用户地址信息
     * @param userId     用户的ID
     * @return Long
     */
    @RequestMapping(value = "/user/{userId}/address", produces = "application/json", method = RequestMethod.POST)
    @ApiOperation(value = "新增用户地址信息", notes = "新增用户地址信息 \t\n userId：用户ID addressDto：用户地址信息ID")
    @Capability(capabilityCode = "user.user-info.add-address")
    RestResponse<Long> addAddress(@PathVariable("userId") Long userId, @Valid @RequestBody AddressDto addressDto);

    /**
     * 修改地址信息
     *
     * @param userId     用户Id
     * @param addressId  用户地址Id
     * @param addressDto 用户地址信息
     * @return Long
     */
    @RequestMapping(value = "/user/{userId}/address/{addressId}", produces = "application/json", method = RequestMethod.PUT)
    @ApiOperation(value = "修改用户地址信息", notes = "修改用户地址信息 \t\n userId：用户ID，addressId：用户地址ID， addressDto：用户地址信息ID")
    @Capability(capabilityCode = "user.user-info.update-address")
    RestResponse<Long> updateAddress(@NotNull @PathVariable("userId") Long userId,
                                     @NotNull @PathVariable("addressId") Long addressId,
                                     @RequestBody AddressDto addressDto);

    /**
     * 删除地址信息
     *
     * @param addressId 地址的ID
     * @return Long
     * @see IUserInfoApi#deleteAddressByUserIdAndAddressId(Long, Long)
     */
    @Deprecated
    @RequestMapping(value = "/address/{addressId}", produces = "application/json", method = RequestMethod.DELETE)
    @ApiOperation(value = "删除用户地址信息，使用/v1/user-info/user/{userId}/address/{addressId}代替", notes = "删除用户地址信息")
    @Capability(capabilityCode = "user.user-info.delete-address")
    RestResponse<Long> deleteAddress(@NotNull @PathVariable("addressId") Long addressId);

    /**
     * 删除地址信息
     *
     * @param addressId 地址的ID
     * @return Long
     */
    @RequestMapping(value = "/user/{userId}/address/{addressId}", produces = "application/json", method = RequestMethod.DELETE)
    @ApiOperation(value = "删除用户地址信息", notes = "删除用户地址信息")
    @Capability(capabilityCode = "user.user-info.delete-address-by-user-id-and-address-id")
    RestResponse<Long> deleteAddressByUserIdAndAddressId(@PathVariable("userId") Long userId, @NotNull @PathVariable("addressId") Long addressId);

    /**
     * 设置为默认地址
     *
     * @param id 地址Id
     * @return void
     * @see IUserInfoApi#setDefaultAddressByUserIdAndAddressId(Long, Long)
     */
    @Deprecated
    @RequestMapping(value = {"/address/{id}/to/default"}, produces = "application/json", method = RequestMethod.PUT)
    @ApiOperation(value = "设置默认地址，使用/v1/user-info/user/{userId}/address/{id}/to/default代替", notes = "设置默认地址,每个用户下的地址只有一个是地址是默认的")
    @ApiImplicitParam(name = "id", value = "地址Id", dataType = "long", paramType = "path", required = true)
    @Capability(capabilityCode = "user.user-info.set-default-address")
    RestResponse<Void> setDefaultAddress(@NotNull @PathVariable("id") Long id);

    /**
     * 设置为默认地址
     *
     * @param userId 用户ID
     * @param id     地址Id
     * @return void
     */
    @RequestMapping(value = {"/user/{userId}/address/{id}/to/default"}, produces = "application/json", method = RequestMethod.PUT)
    @ApiOperation(value = "设置默认地址", notes = "设置默认地址,每个用户下的地址只有一个是地址是默认的")
    @ApiImplicitParam(name = "id", value = "地址Id", dataType = "long", paramType = "path", required = true)
    @Capability(capabilityCode = "user.user-info.set-default-address-by-user-id-and-address-id")
    RestResponse<Void> setDefaultAddressByUserIdAndAddressId(@PathVariable("userId") Long userId, @NotNull @PathVariable("id") Long id);

    /**
     * 新增设备信息
     *
     * @param deviceDto 设备信息
     */
    @RequestMapping(value = "/device", produces = "application/json", method = RequestMethod.POST)
    @ApiOperation(value = "新增设备信息", notes = "新增设备信息")
    @Capability(capabilityCode = "user.user-info.add-device")
    RestResponse<Long> addDevice(@Valid @RequestBody DeviceReqDto deviceDto);


}
