package com.dtyunxi.yundt.cube.center.user.api.constant;

import java.util.HashMap;
import java.util.Map;

/**
 * 第三方查询类型
 *
 * @author zhang.youyang
 * @date 2019-03-29
 */

public enum ThirdQueryType {
    /**
     * 默认,openId > unionId
     */
    DEFAULT(0),
    OPENID_ONLY(1),
    UNIONID_ONLY(2),
    UNIONID_FIRST(3);

    private final int code;

    private static Map<Integer, ThirdQueryType> codeMapping = new HashMap<>();

    static {
        for (ThirdQueryType type : values()) {
            codeMapping.put(type.code, type);
        }
    }

    public static ThirdQueryType fromCode(int code) {
        return codeMapping.get(code);
    }

    ThirdQueryType(int code) {
        this.code = code;
    }


    public int getCode() {
        return code;
    }

}
