/**
 * @(#)AppInstanceDto.java 1.0 May 17, 2018
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * 实例应用Dto
 * 用于实例应用的数据传输对象
 *
 * @author 南枫
 * @since 1.0.0
 */
public class AppInstanceDto extends BaseDto {
    private static final long serialVersionUID = 8419952058782958833L;
    /**
     * 业务空间code
     */
    @ApiModelProperty(value = "业务空间code")
    private String bizSpaceCode;

    /**
     * 业务空间名称
     */
    @ApiModelProperty(value = "业务空间名称")
    private String bizSpaceName;

    @ApiModelProperty(value = "id")
    private Long id;

    /**
     * 应用实例编码
     */
    @ApiModelProperty(value = "编码")
    private String code;
    /**
     * 用户ID
     */
    @ApiModelProperty(value = "用户id")
    @NotNull
    private Long owner;
    /**
     * 用户名称
     */
    @ApiModelProperty(value = "用户名称")
    private String ownerName;
    /**
     * 应用实例名称
     */
    @ApiModelProperty(value = "应用名称")
    private String appInsName;
    /**
     * 应用实例对应应用名称
     */
    @ApiModelProperty(value = "应用实例对应应用模板名称")
    private String appName;

    /**
     * 归属的业务空间ID
     */
    @ApiModelProperty(value = "归属的业务空间ID,0表示直接归属到租户")
    private Long bizSpaceId;
    /**
     * 应用对应应用模板的code
     */
    @ApiModelProperty(value = "应用实例对应应用模板的code")
    private String applicationCode;
    /**
     * 应用实例对应应用的Id
     */
    @ApiModelProperty(value = "应用实例对应应用模板的Id")
    private Long applicationId;
    /**
     * 访问入口
     */
    @ApiModelProperty(value = "访问入口")
    private String hostName;
    /**
     * 域名入口
     */
    @ApiModelProperty(value = "域名入口")
    private String serverName;
    /**
     * 应用实例key
     */
    @ApiModelProperty(value = "应用实例key")
    private String appInsKey;
    /**
     * 订购类型：1，购买；2，体验
     */
    @ApiModelProperty(value = "订购类型：1，购买；2，体验")
    private Integer purchaseType;
    /**
     * 状态：1，启用；2，禁用
     */
    @ApiModelProperty(value = "状态：1，启用；2，禁用")
    private Integer status;

    /**
     * 数据初始化状态,由应用自己决定具体内容
     */
    @ApiModelProperty(value = "数据初始化状态,由应用自己决定具体内容,不超过20个字符")
    private String dataInitStatus;
    /**
     * 有效开始日期
     */
    @ApiModelProperty(value = "有效开始日期 格式：yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date effectiveStartDate;
    /**
     * 有效结束日期
     */
    @ApiModelProperty(value = "有效结束日期 格式：yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date effectiveEndDate;
    /**
     * 应用key
     */
    @ApiModelProperty(value = "应用key")
    private String appKey;
    /**
     * 应用secret
     */
    @ApiModelProperty(value = "应用secret")
    private String appSecret;
    /**
     * 资源菜单列表
     */
    @ApiModelProperty(value = "资源菜单列表")
    private MenuDto menus;
    /**
     * 资源按钮列表
     */
    @ApiModelProperty(value = "资源按钮列表")
    private List<ButtonDto> buttons = new ArrayList<>();

    /**
     * 套餐Id
     */
    @ApiModelProperty(value = "套餐Id")
    private Long appPackageId;

    /**
     * 应用默认使用的账号域, 默认取值为"default"
     */
    @ApiModelProperty(value = "应用默认使用的账号域")
    private String defDomain;

    /**
     * 默认之外, 应用其他支持的账号域, 可有多个,用英文半角逗号分隔
     */
    @ApiModelProperty(value = "默认之外, 应用其他支持的账号域, 可有多个,用英文半角逗号分隔")
    private Set<String> trustDomain;

    /**
     * 请求方的url
     */
    @ApiModelProperty(value = "请求方的url")
    private String requestUrl;

    /**
     * 应用logo
     */
    @ApiModelProperty(value = "应用logo ")
    private String logoUrl;

    /**
     * 应用描述
     */
    @ApiModelProperty(value = "应用描述 ")
    private String description;

    /**
     * 应用接入BOC方式，1嵌入BOC，2跳转新页面
     */
    @ApiModelProperty(value = "应用接入BOC方式，1嵌入BOC，2跳转新页面")
    private Integer jumpType;

    /**
     * 足迹页签，0不需要，1需要
     */
    @ApiModelProperty(value = "足迹页签，0不需要，1需要")
    private Integer footTable;

    /**
     * 应用渠道，1自建应用，2第三方应用，3合作应用
     */
    @ApiModelProperty(value = "应用渠道，1自建应用，2第三方应用，3合作应用")
    private Integer instanceChannel = 1;

    /**
     * 业务类型，1toB，2toC
     */
    @ApiModelProperty(value = "业务类型，1toB，2toC")
    private Integer businessType = 1;

    /**
     * 终端类型，1PC，2手机
     */
    @ApiModelProperty(value = "终端类型，1PC，2手机")
    private Integer terminalType = 1;

    /**
     * 账号，对应基础数据中心表channel_account字段account，第三方应用才有值
     */
    @ApiModelProperty(value = "账号，对应基础数据中心表channel_account字段account，第三方应用才有值")
    private String account;

    /**
     * 账号类型，[0微信订阅号 1微信服务号 2微信小程序 3抖音 4快手 5淘宝 6支付宝 7facebook 8企业微信]
     */
    @ApiModelProperty(value = "账号类型，[0微信订阅号 1微信服务号 2微信小程序 3抖音 4快手 5淘宝 6支付宝 7facebook 8企业微信]")
    private Integer accountType;

    /**
     * 应用配置信息，json存储格式，第三方应用才有值
     */
    @ApiModelProperty(value = "应用配置信息，json存储格式，第三方应用才有值")
    private String instanceConfig;

    public String getBizSpaceName() {
        return bizSpaceName;
    }

    public void setBizSpaceName(String bizSpaceName) {
        this.bizSpaceName = bizSpaceName;
    }

    public String getBizSpaceCode() {
        return bizSpaceCode;
    }

    public void setBizSpaceCode(String bizSpaceCode) {
        this.bizSpaceCode = bizSpaceCode;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Long getAppPackageId() {
        return appPackageId;
    }

    public void setAppPackageId(Long appPackageId) {
        this.appPackageId = appPackageId;
    }

    public String getAppInsName() {
        return appInsName;
    }

    public void setAppInsName(String appInsName) {
        this.appInsName = appInsName;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getOwnerName() {
        return ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getOwner() {
        return owner;
    }

    public void setOwner(Long owner) {
        this.owner = owner;
    }

    public String getAppInsKey() {
        return appInsKey;
    }

    public void setAppInsKey(String appInsKey) {
        this.appInsKey = appInsKey;
    }

    public Integer getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(Integer purchaseType) {
        this.purchaseType = purchaseType;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Date getEffectiveStartDate() {
        return effectiveStartDate;
    }

    public void setEffectiveStartDate(Date effectiveStartDate) {
        this.effectiveStartDate = effectiveStartDate;
    }

    public Date getEffectiveEndDate() {
        return effectiveEndDate;
    }

    public void setEffectiveEndDate(Date effectiveEndDate) {
        this.effectiveEndDate = effectiveEndDate;
    }

    public MenuDto getMenus() {
        return menus;
    }

    public void setMenus(MenuDto menus) {
        this.menus = menus;
    }

    public List<ButtonDto> getButtons() {
        return buttons;
    }

    public void setButtons(List<ButtonDto> buttons) {
        this.buttons = buttons;
    }

    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getAppSecret() {
        return appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public String getHostName() {
        return hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getServerName() {
        return serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getApplicationCode() {
        return applicationCode;
    }

    public void setApplicationCode(String applicationCode) {
        this.applicationCode = applicationCode;
    }

    public Long getApplicationId() {
        return applicationId;
    }

    public void setApplicationId(Long applicationId) {
        this.applicationId = applicationId;
    }

    public Long getBizSpaceId() {
        return bizSpaceId;
    }

    public AppInstanceDto setBizSpaceId(Long bizSpaceId) {
        this.bizSpaceId = bizSpaceId;
        return this;
    }

    public String getDataInitStatus() {
        return dataInitStatus;
    }

    public AppInstanceDto setDataInitStatus(String dataInitStatus) {
        this.dataInitStatus = dataInitStatus;
        return this;
    }

    public String getDefDomain() {
        return defDomain;
    }

    public void setDefDomain(String defDomain) {
        this.defDomain = defDomain;
    }

    public Set<String> getTrustDomain() {
        return trustDomain;
    }

    public void setTrustDomain(Set<String> trustDomain) {
        this.trustDomain = trustDomain;
    }


    public String getRequestUrl() {
        return requestUrl;
    }

    public void setRequestUrl(String requestUrl) {
        this.requestUrl = requestUrl;
    }

    public String getLogoUrl() {
        return logoUrl;
    }

    public void setLogoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getJumpType() {
        return jumpType;
    }

    public void setJumpType(Integer jumpType) {
        this.jumpType = jumpType;
    }

    public Integer getFootTable() {
        return footTable;
    }

    public void setFootTable(Integer footTable) {
        this.footTable = footTable;
    }

    public Integer getInstanceChannel() {
        return instanceChannel;
    }

    public void setInstanceChannel(Integer instanceChannel) {
        this.instanceChannel = instanceChannel;
    }

    public Integer getBusinessType() {
        return businessType;
    }

    public void setBusinessType(Integer businessType) {
        this.businessType = businessType;
    }

    public Integer getTerminalType() {
        return terminalType;
    }

    public void setTerminalType(Integer terminalType) {
        this.terminalType = terminalType;
    }

    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getInstanceConfig() {
        return instanceConfig;
    }

    public void setInstanceConfig(String instanceConfig) {
        this.instanceConfig = instanceConfig;
    }

    public Integer getAccountType() {
        return accountType;
    }

    public void setAccountType(Integer accountType) {
        this.accountType = accountType;
    }
}
