/**
 * @(#)InvoiceInfoDto.java 1.0 June 17, 2018
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 开票信息Dto
 * 用于开票类型,内容,银行信息等数据传输对象
 *
 * @author 伊泽
 * @since 1.0.0
 */
@ApiModel(value = "BillInfoDto", description = "开票信息")
public class BillInfoDto extends BaseDto {
    private static final long serialVersionUID = 7575271663959274576L;

    /**
     * id
     */
    @ApiModelProperty(value = "id")
    private Long id;

    /**
     * 用户Id
     */
    @ApiModelProperty(value = "用户Id")
    private Long userId;

    /**
     * 发票类型
     * 0 普通发票   1 专用发票
     */
    @ApiModelProperty(value = "发票类型:0 普通发票 ；1 专用发票，选填")
    private Integer invoiceType;

    /**
     * 发票抬头类型
     * 0 个人     1 组织
     */
    @ApiModelProperty(value = "发票抬头类型:0 个人；1 组织，选填")
    private Integer invoiceTitleType;

    /**
     * 增值税发票类型
     * 0 普通发票   1 专用发票
     */
    @ApiModelProperty(value = "增值税发票类型：0 普通发票；1 专用发票，选填")
    private Integer addValueInvoiceType;

    /**
     * 单位名称
     */
    @NotNull(message = "单位名称不能为null")
    @ApiModelProperty(value = "单位名称，必填")
    private String companyName;

    /**
     * 发票内容类型
     */
    @ApiModelProperty(value = "发票内容类型，选填")
    private String invoiceContentType;

    /**
     * 发票内容
     */
    @ApiModelProperty(value = "发票内容，选填")
    private String invoiceContent;

    /**
     * 发票抬头
     */
    @ApiModelProperty(value = "发票抬头，选填")
    private String invoiceTitle;

    /**
     * 开户银行
     */
    @ApiModelProperty(value = "开户银行，选填")
    private String depositBank;

    /**
     * 银行账号
     */
    @ApiModelProperty(value = "银行账号，选填")
    private String bankAccount;

    /**
     * 开票地址
     */
    @ApiModelProperty(value = "开票地址，选填")
    private String invoiceAddress;

    /**
     * 税号
     */
    @NotNull(message = "税号不能为null")
    @ApiModelProperty(value = "税号，必填")
    private String dutyNum;

    /**
     * 电话
     */
    @ApiModelProperty(value = "电话，选填")
    private String tel;

    /**
     * 是否默认发票内容
     * 0 不是默认发票内容   1 是默认发票内容
     */
    @ApiModelProperty(value = "发票内容状态: 0 不是默认发票内容   1 是默认发票内容，选填")
    private Integer invoiceStatus;

    /**
     * 寄送方式
     */
    @ApiModelProperty(value = "寄送方式，选填")
    private String sendWay;

    /**
     * 联系人
     */
    @ApiModelProperty(value = "联系人，选填")
    private String linkman;

    /**
     * 联系电话
     */
    @ApiModelProperty(value = "联系电话，选填")
    private String phoneNum;

    /**
     * 联系地址
     */
    @ApiModelProperty(value = "联系地址，选填")
    private String linkAddress;

    /**
     * 省编号
     */
    @ApiModelProperty(value = "省编号，选填")
    private String provinceCode;

    /**
     * 市编号
     */
    @ApiModelProperty(value = "市编号，选填")
    private String cityCode;

    /**
     * 区编号
     */
    @ApiModelProperty(value = "区编号，选填")
    private String districtCode;

    /**
     * 街道编号
     */
    @ApiModelProperty(value = "街道编号，选填")
    private String streetCode;

    /**
     * 邮编
     */
    @ApiModelProperty(value = "邮编，选填")
    private String postcode;


    /**
     * 所在省名称
     */
    @ApiModelProperty(value = "所在省名称，选填")
    private String province;

    /**
     * 所在市名称
     */
    @ApiModelProperty(value = "所在市名称，选填")
    private String city;

    /**
     * 所在区名称
     */
    @ApiModelProperty(value = "所在区名称，选填")
    private String district;

    /**
     * 第三方Id
     */
    @ApiModelProperty(value = "第三方Id，选填")
    private Long thirdId;

    /**
     * 生效时间
     */
    @DateTimeFormat(iso = DateTimeFormat.ISO.DATE)
    @ApiModelProperty(value = "生效时间，选填")
    private Date takeEffTime;

    /**
     * 失效时间
     */
    @DateTimeFormat(iso = DateTimeFormat.ISO.DATE)
    @ApiModelProperty(value = "失效时间，选填")
    private Date loseEffTime;

    /**
     * 组织信息Id
     */
    @ApiModelProperty(name = "orgInfoId ", value = "组织信息Id")
    private Long orgInfoId;

    /**
     * 支付宝号
     */
    @ApiModelProperty(name = "alipayNumber ", value = "支付宝号")
    private String alipayNumber;

    /**
     * 微信号
     */
    @ApiModelProperty(name = "wechatNumber ", value = "微信号")
    private String wechatNumber;

    public String getAlipayNumber() {
        return alipayNumber;
    }

    public void setAlipayNumber(String alipayNumber) {
        this.alipayNumber = alipayNumber;
    }

    public String getWechatNumber() {
        return wechatNumber;
    }

    public void setWechatNumber(String wechatNumber) {
        this.wechatNumber = wechatNumber;
    }

    /**
     * 正向排序字段（多个字段以逗号分隔）
     */
    private String orderBy;

    /**
     * 倒序排序字段（多个字段以逗号分隔）
     */
    private String orderByDesc;

    public Long getOrgInfoId() {
        return orgInfoId;
    }

    public void setOrgInfoId(Long orgInfoId) {
        this.orgInfoId = orgInfoId;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Integer getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(Integer invoiceType) {
        this.invoiceType = invoiceType;
    }

    public Integer getInvoiceTitleType() {
        return invoiceTitleType;
    }

    public void setInvoiceTitleType(Integer invoiceTitleType) {
        this.invoiceTitleType = invoiceTitleType;
    }

    public Integer getAddValueInvoiceType() {
        return addValueInvoiceType;
    }

    public void setAddValueInvoiceType(Integer addValueInvoiceType) {
        this.addValueInvoiceType = addValueInvoiceType;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getInvoiceContentType() {
        return invoiceContentType;
    }

    public void setInvoiceContentType(String invoiceContentType) {
        this.invoiceContentType = invoiceContentType;
    }

    public String getInvoiceContent() {
        return invoiceContent;
    }

    public void setInvoiceContent(String invoiceContent) {
        this.invoiceContent = invoiceContent;
    }

    public String getInvoiceTitle() {
        return invoiceTitle;
    }

    public void setInvoiceTitle(String invoiceTitle) {
        this.invoiceTitle = invoiceTitle;
    }

    public String getDepositBank() {
        return depositBank;
    }

    public void setDepositBank(String depositBank) {
        this.depositBank = depositBank;
    }

    public String getBankAccount() {
        return bankAccount;
    }

    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount;
    }

    public String getInvoiceAddress() {
        return invoiceAddress;
    }

    public void setInvoiceAddress(String invoiceAddress) {
        this.invoiceAddress = invoiceAddress;
    }

    public String getDutyNum() {
        return dutyNum;
    }

    public void setDutyNum(String dutyNum) {
        this.dutyNum = dutyNum;
    }

    public String getTel() {
        return tel;
    }

    public void setTel(String tel) {
        this.tel = tel;
    }

    public Integer getInvoiceStatus() {
        return invoiceStatus;
    }

    public void setInvoiceStatus(Integer invoiceStatus) {
        this.invoiceStatus = invoiceStatus;
    }

    public String getSendWay() {
        return sendWay;
    }

    public void setSendWay(String sendWay) {
        this.sendWay = sendWay;
    }

    public String getLinkman() {
        return linkman;
    }

    public void setLinkman(String linkman) {
        this.linkman = linkman;
    }

    public String getPhoneNum() {
        return phoneNum;
    }

    public void setPhoneNum(String phoneNum) {
        this.phoneNum = phoneNum;
    }

    public String getLinkAddress() {
        return linkAddress;
    }

    public void setLinkAddress(String linkAddress) {
        this.linkAddress = linkAddress;
    }

    public Date getTakeEffTime() {
        return takeEffTime;
    }

    public void setTakeEffTime(Date takeEffTime) {
        this.takeEffTime = takeEffTime;
    }

    public Date getLoseEffTime() {
        return loseEffTime;
    }

    public void setLoseEffTime(Date loseEffTime) {
        this.loseEffTime = loseEffTime;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getThirdId() {
        return thirdId;
    }

    public void setThirdId(Long thirdId) {
        this.thirdId = thirdId;
    }

    public String getProvinceCode() {
        return provinceCode;
    }

    public void setProvinceCode(String provinceCode) {
        this.provinceCode = provinceCode;
    }

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getDistrictCode() {
        return districtCode;
    }

    public void setDistrictCode(String districtCode) {
        this.districtCode = districtCode;
    }

    public String getStreetCode() {
        return streetCode;
    }

    public void setStreetCode(String streetCode) {
        this.streetCode = streetCode;
    }

    public String getPostcode() {
        return postcode;
    }

    public void setPostcode(String postcode) {
        this.postcode = postcode;
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getDistrict() {
        return district;
    }

    public void setDistrict(String district) {
        this.district = district;
    }

    public void setLinkDistrict(String linkDistrict) {
        linkDistrict = linkDistrict;
    }

    public String getOrderBy() {
        return orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public String getOrderByDesc() {
        return orderByDesc;
    }

    public void setOrderByDesc(String orderByDesc) {
        this.orderByDesc = orderByDesc;
    }
}
