package com.dtyunxi.yundt.cube.center.user.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 *
 * @author luban
 * @date 2020-06-18
 */ 
@ApiModel(value = "ChartDto", description = "报表信息")
public class ChartDto extends BaseDto{

    /**
     * 报表主键
     */
    @ApiModelProperty(value = "报表主键")
    private Long id;

    /**
     * 报表编码
     */
    @ApiModelProperty(name = "报表编码", value = "code")
    private String code;

    /**
     * 报表名称
     */
    @ApiModelProperty(value = "报表名称")
    private String name;

    /**
     * 报表分类
     */
    @ApiModelProperty(value = "报表分类")
    private String type;

    /**
     * 横坐标名称
     */
    @ApiModelProperty(value = "横坐标名称")
    private String abscissaName;

    /**
     * 横坐标最大值
     */
    @ApiModelProperty(value = "横坐标最大值")
    private Integer abscissaMax;

    /**
     * 横坐标单位
     */
    @ApiModelProperty(value = "横坐标单位")
    private String abscissaUnit;

    /**
     * 纵坐标名称
     */
    @ApiModelProperty(value = "纵坐标名称")
    private String ordinateName;

    /**
     * 纵坐标最大值
     */
    @ApiModelProperty(value = "纵坐标最大值")
    private Integer ordinateMax;

    @ApiModelProperty(value = "纵坐标单位")
    private String ordinateUnit;

    /**
     * 前端跳转地址
     */
    @ApiModelProperty(value = "前端跳转地址")
    private String webUrl;

    /**
     * 后端API地址
     */
    @ApiModelProperty(value = "后端API地址")
    private String serverUrl;

    /**
     * 配置类型 1-可配置， 0-不可配置
     */
    @ApiModelProperty(value = "配置类型：1-可配置， 0-不可配置")
    private Integer configType;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getWebUrl() {
        return webUrl;
    }

    public void setWebUrl(String webUrl) {
        this.webUrl = webUrl;
    }

    public String getServerUrl() {
        return serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String getAbscissaName() {
        return abscissaName;
    }

    public void setAbscissaName(String abscissaName) {
        this.abscissaName = abscissaName;
    }

    public Integer getAbscissaMax() {
        return abscissaMax;
    }

    public void setAbscissaMax(Integer abscissaMax) {
        this.abscissaMax = abscissaMax;
    }

    public String getAbscissaUnit() {
        return abscissaUnit;
    }

    public void setAbscissaUnit(String abscissaUnit) {
        this.abscissaUnit = abscissaUnit;
    }

    public String getOrdinateName() {
        return ordinateName;
    }

    public void setOrdinateName(String ordinateName) {
        this.ordinateName = ordinateName;
    }

    public Integer getOrdinateMax() {
        return ordinateMax;
    }

    public void setOrdinateMax(Integer ordinateMax) {
        this.ordinateMax = ordinateMax;
    }

    public String getOrdinateUnit() {
        return ordinateUnit;
    }

    public void setOrdinateUnit(String ordinateUnit) {
        this.ordinateUnit = ordinateUnit;
    }

    public Integer getConfigType() {
        return configType;
    }

    public void setConfigType(Integer configType) {
        this.configType = configType;
    }
}
