/**
 * @(#) PersonalInfoExtDto.java 1.0 2019/1/18
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author 米修
 * @date 2019/1/18
 * @since 1.0.0
 */
@ApiModel(value = "PersonalInfoExtDto", description = "个人信息扩展Dto")
public class PersonalInfoExtDto extends PersonalInfoDto {

    /**
     * 外部服务的用户唯一标识UID
     */
    @ApiModelProperty(value = "外部服务的用户唯一标识UID")
    private Long sourceUid;

    /**
     * 手机号码
     */
    @ApiModelProperty(value = "手机号码")
    private String phone;

    /**
     * 邮箱
     */
    @ApiModelProperty(value = "邮箱")
    private String email;

    /**
     * 客户类型：0游客，1注册用户
     */
    @ApiModelProperty(value = "客户类型")
    private Integer type;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remark;

    /**
     * 等级
     */
    @ApiModelProperty(value = "等级")
    private Integer grade;

    public Long getSourceUid() {
        return sourceUid;
    }

    public void setSourceUid(Long sourceUid) {
        this.sourceUid = sourceUid;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Integer getGrade() {
        return grade;
    }

    public void setGrade(Integer grade) {
        this.grade = grade;
    }

    public PersonalInfoExtDto() {
    }
}
