/**
 * @(#) RegisterChannelDto.java 1.0 2018-06-01
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;


/**
 * 注册通道Dto
 * 用于设置注册通道类型的数据传输对象
 *
 * @author 伊泽
 * @since 1.0.0
 */
@ApiModel(value = "RegisterChannelDto", description = "注册渠道")
public class RegisterChannelDto extends BaseDto {
    private static final long serialVersionUID = -418559924141570407L;

    /**
     * id
     */
    @ApiModelProperty(value = "id")
    private Long id;


    /**
     * 渠道名称
     */
    @NotNull(message = "渠道名称不能为null")
    @ApiModelProperty(value = "渠道名称, 必填")
    private String name;

    /**
     * 渠道编码
     */
    @NotNull(message = "渠道编码不能为null")
    @ApiModelProperty(value = "渠道编码, 必填")
    private String code;

    /**
     * 渠道类型
     */
    @NotNull(message = "渠道类型不能为null")
    @ApiModelProperty(value = "渠道类型, 必填")
    private String type;

    /**
     * 渠道状态（默认启用）
     * 0 禁用   1 启用
     */
    @ApiModelProperty(value = "渠道状态: 0 禁用   1 启用", allowEmptyValue = true)
    private Integer status;

    @ApiModelProperty(value = "创建者Id")
    private Long ownerId;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Long getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
    }
}
