/**
 * @(#) AccessDto.java 1.0 2018-06-15
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.user.api.dto;

import com.google.common.collect.Sets;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Set;


/**
 * 角色权限Dto
 * 用于对角色权限的分配以及查询的数据传输对象
 *
 * @author 黑马
 * @since 1.0.0
 */
@ApiModel(value = "RoleAccessDto", description = "角色权限")
public class RoleAccessDto extends BaseDto {
    private static final long serialVersionUID = -7389545951869899928L;

    /**
     * 角色Id
     */
    @ApiModelProperty("角色ID，必填")
    private Long roleId;

    /**
     * 角色code
     */
    @ApiModelProperty("角色code,必填")
    private String code;

    /**
     * 权限列表
     */
    @ApiModelProperty("权限列表，必填")
    private Set<AccessDto> accessSet = Sets.newHashSet();

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Long getRoleId() {
        return roleId;
    }

    public void setRoleId(Long roleId) {
        this.roleId = roleId;
    }

    public Set<AccessDto> getAccessSet() {
        return accessSet;
    }

    public void setAccessSet(Set<AccessDto> accessSet) {
        this.accessSet = accessSet;
    }
}
