package com.dtyunxi.yundt.cube.center.user.api.dto;

import io.swagger.annotations.ApiModel;

/**
 * The persistent class for the table_extra_property database table.
 */
@ApiModel(value = "TableExtraPropertyDto", description = "表属性扩展")
public class TableExtraPropertyDto extends BaseDto {
    private static final long serialVersionUID = 1L;
    private Long id;
    private String extraParams;
    private Long primaryKeyId;
    private String tableName;

    public static TableExtraPropertyDto createTableExtraPropertyDto(String tableName, Long primaryKeyId, String extraParams) {
        TableExtraPropertyDto dto = new TableExtraPropertyDto();
        dto.setTableName(tableName);
        dto.setPrimaryKeyId(primaryKeyId);
        dto.setExtraParams(extraParams);
        return dto;
    }

    public static TableExtraPropertyDto createTableExtraPropertyDto(String tableName, Long primaryKeyId, String extraParams, Long instanceId, Long tenantId) {
        TableExtraPropertyDto dto = new TableExtraPropertyDto();
        dto.setTableName(tableName);
        dto.setPrimaryKeyId(primaryKeyId);
        dto.setExtraParams(extraParams);
        dto.setInstanceId(instanceId);
        dto.setTenantId(tenantId);
        return dto;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getExtraParams() {
        return extraParams;
    }

    public void setExtraParams(String extraParams) {
        this.extraParams = extraParams;
    }

    public Long getPrimaryKeyId() {
        return primaryKeyId;
    }

    public void setPrimaryKeyId(Long primaryKeyId) {
        this.primaryKeyId = primaryKeyId;
    }

    public String getTableName() {
        return tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

}
