/*
 * @(#)TenantDto.java 1.0 2018/9/3
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.user.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Set;

/**
 * 租户Dto
 * 用于租户查询的数据传输对象
 *
 * @author 古奇
 * @since 1.0.0
 */
@ApiModel(value = "TenantDto", description = "租户")
public class TenantDto extends BaseDto {
    private static final long serialVersionUID = -2364826315490444375L;

    @ApiModelProperty(value = "租户ID，新增时不填")
    private Long id;

    /**
     * 租户编码
     */
    @ApiModelProperty(value = "编码，选填")
    private String tenantCode;

    /**
     * 租户名称
     */
    @ApiModelProperty(value = "名称，选填")
    private String tenantName;

    /**
     * 域名
     */
    @ApiModelProperty(value = "域名，选填")
    private String domain;

    /**
     * 1启用登录 2禁用登录
     */
    @ApiModelProperty(value = "1启用2禁用，选填")
    private Integer status;

    /**
     * 用户Id
     */
    @ApiModelProperty(value = "用户Id，选填")
    private Long userId;

    /**
     * 地址
     */
    @ApiModelProperty(value = "地址，选填")
    private String address;

    /**
     * 联系人
     */
    @ApiModelProperty(value = "联系人，选填")
    private String linkName;

    /**
     * 手机
     */
    @ApiModelProperty(value = "手机，选填")
    private String phone;

    /**
     * 管理员账号
     */
    @ApiModelProperty(value = "管理员账号，选填")
    private String userName;

    /**
     * 租户隔离级别
     */
    @ApiModelProperty(value = "租户隔离级别，选填。1：域隔离；2：实例隔离，不填默认1域隔离")
    private Integer isolation;

    /**
     * 密码
     */
    @ApiModelProperty(value = "密码")
    private String password;

    /**
     * 租户信任域
     */
    @ApiModelProperty(value = "租户信任域，租户ID，多个以:分隔，选填")
    private String trustDomain;

    @ApiModelProperty(value = "租户域名")
    private String host;

    /**
     * 是否同步创建管理员账号（1=是 0=否）
     */
    @ApiModelProperty(value = "1=是 0=否，默认为0，兼容旧版本接口")
    private Boolean isCreateAccount = false;

    /**
     * 默认账号域
     */
    @ApiModelProperty(value = "默认账号域")
    private String defDomain;

    /**
     * 除默认账号域外的其他可用账号域
     */
    @ApiModelProperty(value = "除默认账号域外的其他可用账号域")
    private Set<String> availableDomain;

    /**
     * 同时查询租户及应用信息，登录性能调优
     */
    private AppInstanceDto appInstanceDto;

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getIsolation() {
        return isolation;
    }

    public void setIsolation(Integer isolation) {
        this.isolation = isolation;
    }

    public String getTrustDomain() {
        return trustDomain;
    }

    public void setTrustDomain(String trustDomain) {
        this.trustDomain = trustDomain;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTenantCode() {
        return tenantCode;
    }

    public void setTenantCode(String tenantCode) {
        this.tenantCode = tenantCode;
    }

    public String getTenantName() {
        return tenantName;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public String getDomain() {
        return domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getLinkName() {
        return linkName;
    }

    public void setLinkName(String linkName) {
        this.linkName = linkName;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Boolean getCreateAccount() {
        return isCreateAccount;
    }

    public void setCreateAccount(Boolean createAccount) {
        isCreateAccount = createAccount;
    }

    public String getDefDomain() {
        return defDomain;
    }

    public void setDefDomain(String defDomain) {
        this.defDomain = defDomain;
    }

    public Set<String> getAvailableDomain() {
        return availableDomain;
    }

    public void setAvailableDomain(Set<String> availableDomain) {
        this.availableDomain = availableDomain;
    }

    public AppInstanceDto getAppInstanceDto() {
        return appInstanceDto;
    }

    public void setAppInstanceDto(AppInstanceDto appInstanceDto) {
        this.appInstanceDto = appInstanceDto;
    }
}
